/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import extensions.net.minecraft.client.resources.model.BakedModel.ABI;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemModel;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinModelManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.PoseStackWrapper;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class BakedItemTransform
implements ISkinTransform {
    private Entity entity;
    private ItemStack itemStack = ItemStack.field_190927_a;
    private AbstractItemTransformType transformType = AbstractItemTransformType.NONE;
    private final ISkinPartType partType;
    private final BakedItemModel itemModel;

    public BakedItemTransform(BakedSkinPart bakedSkinPart, BakedSkin bakedSkin) {
        this.partType = bakedSkinPart.getType();
        this.itemModel = bakedSkin.getItemModel();
    }

    public void setup(Entity entity, SkinItemSource itemSource) {
        this.entity = entity;
        this.transformType = itemSource.getTransformType();
        this.itemStack = itemSource.getItem();
    }

    @Override
    public void apply(IPoseStack poseStack) {
        PoseStackWrapper wrapper = ObjectUtils.safeCast(poseStack, PoseStackWrapper.class);
        if (this.entity == null || wrapper == null) {
            return;
        }
        IBakedModel model = SkinModelManager.getInstance().getModel(this.partType, this.itemModel, this.itemStack, this.entity);
        float f1 = 16.0f;
        float f2 = 0.0625f;
        boolean flag = this.transformType.isLeftHand();
        poseStack.scale(f1, f1, f1);
        ABI.applyTransform(model, wrapper.pose(), flag, this.transformType);
        poseStack.scale(f2, f2, f2);
        if (flag) {
            poseStack.multiply(OpenMatrix4f.createScaleMatrix(-1.0f, 1.0f, 1.0f));
            poseStack.multiply(OpenMatrix3f.createScaleMatrix(-1.0f, 1.0f, 1.0f));
        }
    }
}

