/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIControl;
import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinIconView
extends UIControl {
    private SkinDescriptor descriptor = SkinDescriptor.EMPTY;
    private final Ticket loadTicket = Ticket.list();

    public SkinIconView(CGRect frame) {
        super(frame);
        this.setClipBounds(true);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(this.descriptor, this.loadTicket);
        if (bakedSkin == null) {
            return;
        }
        CGRect rect = this.bounds();
        float tx = rect.x;
        float ty = rect.y;
        float tw = rect.width;
        float th = rect.height;
        float si = Math.min(tw, th);
        MatrixStack poseStack = context.state().ctm();
        ColorScheme colorScheme = this.descriptor.getColorScheme();
        SkinItemSource itemSource = SkinItemSource.EMPTY;
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        poseStack.func_227860_a_();
        poseStack.func_227861_a_((double)(tx + tw / 2.0f), (double)(ty + th / 2.0f), 200.0);
        ABI.mulPoseMatrix(poseStack, OpenMatrix4f.createScaleMatrix(1.0f, -1.0f, 1.0f));
        ABI.mulNormalMatrix(poseStack, OpenMatrix3f.createScaleMatrix(1.0f, -1.0f, 1.0f));
        ABI.mulPose(poseStack, Vector3f.XP.rotationDegrees(30.0f));
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(135.0f));
        poseStack.func_227862_a_(0.625f, 0.625f, 0.625f);
        poseStack.func_227862_a_(si, si, si);
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, colorScheme, Vector3f.ONE, 0.0f, 0xF000F0, itemSource, poseStack, (IRenderTypeBuffer)buffers);
        poseStack.func_227865_b_();
        buffers.func_228461_a_();
    }

    public SkinDescriptor skin() {
        return this.descriptor;
    }

    public void setSkin(SkinDescriptor descriptor) {
        this.loadTicket.invalidate();
        this.descriptor = descriptor;
    }
}

