/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.compatibility.AbstractRenderLayer;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.other.thirdparty.EpicFlightRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.init.ModContributors;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeLayer<T extends Entity, V extends EntityModel<T>, M extends IModel>
extends AbstractRenderLayer<T, V> {
    protected final BakedArmature armature;
    protected final BakedArmatureTransformer armatureTransformer;
    protected final IEntityRenderer<T, V> entityRenderer;

    public SkinWardrobeLayer(BakedArmatureTransformer armatureTransformer, IEntityRenderer<T, V> renderer) {
        super(renderer);
        this.armature = new BakedArmature(armatureTransformer.getArmature());
        this.armatureTransformer = armatureTransformer;
        this.entityRenderer = renderer;
    }

    public void func_225628_a_(MatrixStack poseStack, IRenderTypeBuffer buffers, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ModContributors.Contributor contributor;
        if (entity.func_82150_aj()) {
            return;
        }
        MatrixStack poseStack1 = poseStack;
        Object model = ModelHolder.of((Model)this.func_215332_c());
        SkinRenderData renderData = SkinRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        BakedArmatureTransformer finalTransformer = this.armatureTransformer;
        EpicFlightRenderContext epicFlightContext = renderData.epicFlightContext;
        if (epicFlightContext != null) {
            poseStack = epicFlightContext.getPose();
            finalTransformer = epicFlightContext.getTransformer();
        }
        poseStack.func_227860_a_();
        if (epicFlightContext == null) {
            this.applyModelScale(poseStack, model);
        }
        if ((contributor = ModContributors.by(entity)) != null && renderData.shouldRenderExtra()) {
            this.renderMagicCircle(poseStack1, buffers, ((Entity)entity).field_70173_aa + entity.func_145782_y() * 31, partialTicks, 24, contributor.color, packedLightIn, OverlayTexture.field_229196_a_);
        }
        float f = 0.0625f;
        poseStack.func_227862_a_(f, f, f);
        finalTransformer.applyTo(this.armature);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLightIn, TickUtils.ticks(), null, poseStack, buffers);
        for (SkinRenderData.Entry entry : renderData.getArmorSkins()) {
            context.setReferenced(SkinItemSource.create(entry.getRenderPriority(), entry.getItemStack()));
            BakedSkin bakedSkin = entry.getBakedSkin();
            bakedSkin.setupAnim((Entity)entity, context.getPartialTicks(), context.getReferenced());
            SkinRenderer.render(entity, this.armature, bakedSkin, entry.getBakedScheme(), context);
        }
        context.release();
        poseStack.func_227865_b_();
    }

    public void renderMagicCircle(MatrixStack poseStack, IRenderTypeBuffer buffers, int ticks, float partialTickTime, int offset, int color, int lightmap, int overlay) {
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.0, (double)((float)offset / 16.0f), 0.0);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        float circleScale = 2.0f;
        float rotation = (float)((double)ticks / 0.8 % 360.0) + partialTickTime;
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(rotation));
        poseStack.func_227862_a_(circleScale, circleScale, circleScale);
        Matrix4f pose = poseStack.func_227866_c_().func_227870_a_();
        IVertexBuilder builder = buffers.getBuffer(SkinRenderType.IMAGE_MAGIC);
        builder.func_227888_a_(pose, -1.0f, 0.0f, -1.0f).func_225586_a_(red, green, blue, 255).func_225583_a_(1.0f, 0.0f).func_227891_b_(overlay).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(pose, 1.0f, 0.0f, -1.0f).func_225586_a_(red, green, blue, 255).func_225583_a_(0.0f, 0.0f).func_227891_b_(overlay).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(pose, 1.0f, 0.0f, 1.0f).func_225586_a_(red, green, blue, 255).func_225583_a_(0.0f, 1.0f).func_227891_b_(overlay).func_227886_a_(lightmap).func_181675_d();
        builder.func_227888_a_(pose, -1.0f, 0.0f, 1.0f).func_225586_a_(red, green, blue, 255).func_225583_a_(1.0f, 1.0f).func_227891_b_(overlay).func_227886_a_(lightmap).func_181675_d();
        poseStack.func_227865_b_();
    }

    protected void applyModelScale(MatrixStack poseStack, M model) {
        IModelBabyPose babyPose = model.getBabyPose();
        if (babyPose != null) {
            float scale = 1.0f / babyPose.getHeadScale();
            IVector3f offset = babyPose.getHeadOffset();
            poseStack.func_227862_a_(scale, scale, scale);
            poseStack.func_227861_a_((double)(offset.getX() / 16.0f), (double)(offset.getY() / 16.0f), (double)(offset.getZ() / 16.0f));
        }
    }
}

