/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.client.model.IHumanoidModel;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.client.model.IPlayerModel;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerKey;
import moe.plushie.armourers_workshop.utils.DataStorage;
import moe.plushie.armourers_workshop.utils.ModelPartHolder;

public class CachedModel<P>
implements IModel {
    private final Container<P> container;
    private final DataStorage storage = new DataStorage();

    public CachedModel(Container<P> container) {
        this.container = container;
    }

    @Override
    public IModelBabyPose getBabyPose() {
        return this.container.getBabyPose();
    }

    @Override
    public IModelPart getPart(String name) {
        return this.container.parts.get(name);
    }

    @Override
    public Collection<IModelPart> getAllParts() {
        return this.container.values;
    }

    @Override
    public <T> T getAssociatedObject(IAssociatedContainerKey<T> key) {
        return this.storage.getAssociatedObject(key);
    }

    @Override
    public <T> void setAssociatedObject(T value, IAssociatedContainerKey<T> key) {
        this.storage.setAssociatedObject(value, key);
    }

    @Override
    public Class<?> getType() {
        return this.container.type;
    }

    public static class Container<P> {
        protected IModelBabyPose babyPose;
        protected final Class<?> type;
        protected final Function<P, IModelPart> transformer;
        protected final ArrayList<IModelPart> values = new ArrayList();
        protected final HashMap<String, IModelPart> parts = new HashMap();

        public Container(Class<?> type, Function<P, IModelPart> transformer) {
            this.type = type;
            this.transformer = transformer;
        }

        public void put(String name, P part) {
            IModelPart holder = this.transformer.apply(part);
            this.parts.put(name, holder);
            this.values.add(holder);
            if (holder instanceof ModelPartHolder) {
                ((ModelPartHolder)holder).setName(name);
            }
        }

        public void unnamed(Iterable<P> parts) {
            for (P part : parts) {
                this.values.add(this.transformer.apply(part));
            }
        }

        public IModelBabyPose getBabyPose() {
            return this.babyPose;
        }
    }

    public static class Player<P>
    extends Humanoid<P>
    implements IPlayerModel {
        private final IModelPart ear = IPlayerModel.super.getEarPart();
        private final IModelPart cloak = IPlayerModel.super.getCloakPart();
        private final IModelPart jacket = IPlayerModel.super.getJacketPart();
        private final IModelPart leftSleeve = IPlayerModel.super.getLeftSleevePart();
        private final IModelPart rightSleeve = IPlayerModel.super.getRightSleevePart();
        private final IModelPart leftPants = IPlayerModel.super.getLeftPantsPart();
        private final IModelPart rightPants = IPlayerModel.super.getRightPantsPart();

        public Player(Container<P> container) {
            super(container);
        }

        @Override
        public IModelPart getEarPart() {
            return this.ear;
        }

        @Override
        public IModelPart getCloakPart() {
            return this.cloak;
        }

        @Override
        public IModelPart getJacketPart() {
            return this.jacket;
        }

        @Override
        public IModelPart getLeftSleevePart() {
            return this.leftSleeve;
        }

        @Override
        public IModelPart getRightSleevePart() {
            return this.rightSleeve;
        }

        @Override
        public IModelPart getLeftPantsPart() {
            return this.leftPants;
        }

        @Override
        public IModelPart getRightPantsPart() {
            return this.rightPants;
        }
    }

    public static class Humanoid<P>
    extends CachedModel<P>
    implements IHumanoidModel {
        private final IModelPart hat = IHumanoidModel.super.getHatPart();
        private final IModelPart head = IHumanoidModel.super.getHeadPart();
        private final IModelPart body = IHumanoidModel.super.getBodyPart();
        private final IModelPart leftArm = IHumanoidModel.super.getLeftArmPart();
        private final IModelPart rightArm = IHumanoidModel.super.getRightArmPart();
        private final IModelPart leftLeg = IHumanoidModel.super.getLeftLegPart();
        private final IModelPart rightLeg = IHumanoidModel.super.getRightLegPart();

        public Humanoid(Container<P> container) {
            super(container);
        }

        @Override
        public IModelPart getHatPart() {
            return this.hat;
        }

        @Override
        public IModelPart getHeadPart() {
            return this.head;
        }

        @Override
        public IModelPart getBodyPart() {
            return this.body;
        }

        @Override
        public IModelPart getLeftArmPart() {
            return this.leftArm;
        }

        @Override
        public IModelPart getRightArmPart() {
            return this.rightArm;
        }

        @Override
        public IModelPart getLeftLegPart() {
            return this.leftLeg;
        }

        @Override
        public IModelPart getRightLegPart() {
            return this.rightLeg;
        }
    }
}

