/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import extensions.net.minecraft.client.renderer.block.model.ItemOverrides.Resolver;
import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import java.util.HashMap;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemModel;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkinModelManager {
    static final SkinModelManager INSTANCE = new SkinModelManager();
    final ModelManager modelManager;
    final HashMap<ISkinPartType, IBakedModel> cachedModels = new HashMap();
    final HashMap<ISkinPartType, IBakedModel> cachedItemModels = new HashMap();

    SkinModelManager() {
        this.modelManager = Minecraft.func_71410_x().func_209506_al();
    }

    public static SkinModelManager getInstance() {
        return INSTANCE;
    }

    public IBakedModel getModel(ISkinPartType partType, @Nullable BakedItemModel itemModel, ItemStack itemStack, Entity entity) {
        return this.getModel(partType, itemModel, itemStack, PropertyProvider.getLevel(entity), entity);
    }

    public IBakedModel getModel(ISkinPartType partType, @Nullable BakedItemModel itemModel, ItemStack itemStack, @Nullable World level, @Nullable Entity entity) {
        ClientWorld clientWorld = ObjectUtils.safeCast(level, ClientWorld.class);
        LivingEntity livingEntity = ObjectUtils.safeCast(entity, LivingEntity.class);
        if (itemModel != null) {
            return itemModel.resolve((IBakedModel)itemModel, itemStack, clientWorld, livingEntity, 0);
        }
        IBakedModel bakedModel = this.loadModel(partType);
        return Resolver.resolve(bakedModel.func_188617_f(), bakedModel, itemStack, clientWorld, livingEntity, 0);
    }

    public IBakedModel getMissingModel() {
        return this.modelManager.func_174951_a();
    }

    private IBakedModel loadModel(ISkinPartType partType) {
        IBakedModel bakedModel = this.cachedModels.get(partType);
        if (bakedModel != null) {
            return bakedModel;
        }
        bakedModel = this.modelManager.func_174953_a(ArmourersWorkshop.getCustomModel(partType.getRegistryName()));
        if (partType != SkinPartTypes.UNKNOWN && bakedModel == this.getMissingModel()) {
            bakedModel = this.loadModel(SkinPartTypes.UNKNOWN);
        }
        this.cachedModels.put(partType, bakedModel);
        return bakedModel;
    }
}

