/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.google.common.collect.Iterators;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Iterator;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.PoseStackWrapper;
import moe.plushie.armourers_workshop.utils.PoseUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderContext {
    public static final SkinRenderContext EMPTY = new SkinRenderContext(new MatrixStack());
    private static final Iterator<SkinRenderContext> POOL = Iterators.cycle(ObjectUtils.makeItems(100, i -> new SkinRenderContext(new MatrixStack())));
    private int lightmap = 0xF000F0;
    private int overlay = 0;
    private float partialTicks = 0.0f;
    private IRenderTypeBuffer buffers;
    private SkinRenderData renderData;
    private SkinRenderBufferSource bufferProvider;
    private SkinItemSource itemSource;
    private ColorScheme colorScheme = ColorScheme.EMPTY;
    private AbstractItemTransformType transformType = AbstractItemTransformType.NONE;
    private final MatrixStack defaultPoseStack;
    private final PoseStackWrapper usingPoseStack;

    public SkinRenderContext(MatrixStack poseStack) {
        this.defaultPoseStack = poseStack;
        this.usingPoseStack = PoseUtils.wrap(poseStack);
    }

    public static SkinRenderContext alloc(SkinRenderData renderData, int light, float partialTick, AbstractItemTransformType transformType, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        SkinRenderContext context = POOL.next();
        context.setRenderData(renderData);
        context.setLightmap(light);
        context.setPartialTicks(partialTick);
        context.setTransformType(transformType);
        context.setPose(poseStack);
        context.setBuffers(buffers);
        return context;
    }

    public static SkinRenderContext alloc(SkinRenderData renderData, int light, float partialTick, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        return SkinRenderContext.alloc(renderData, light, partialTick, AbstractItemTransformType.NONE, poseStack, buffers);
    }

    public void release() {
        this.lightmap = 0xF000F0;
        this.partialTicks = 0.0f;
        this.colorScheme = ColorScheme.EMPTY;
        this.transformType = AbstractItemTransformType.NONE;
        this.itemSource = SkinItemSource.EMPTY;
        this.usingPoseStack.set(this.defaultPoseStack);
        this.bufferProvider = null;
        this.renderData = null;
        this.buffers = null;
    }

    public void pushPose() {
        this.usingPoseStack.pushPose();
    }

    public void popPose() {
        this.usingPoseStack.popPose();
    }

    public PoseStackWrapper pose() {
        return this.usingPoseStack;
    }

    public void setLightmap(int lightmap) {
        this.lightmap = lightmap;
    }

    public int getLightmap() {
        return this.lightmap;
    }

    public void setOverlay(int overlay) {
        this.overlay = overlay;
    }

    public int getOverlay() {
        return this.overlay;
    }

    public void setPartialTicks(float partialTicks) {
        this.partialTicks = partialTicks;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public void setTransformType(AbstractItemTransformType transformType) {
        this.transformType = transformType;
    }

    public AbstractItemTransformType getTransformType() {
        return this.transformType;
    }

    public void setReferenced(SkinItemSource itemSource) {
        this.itemSource = itemSource;
    }

    public SkinItemSource getReferenced() {
        if (this.itemSource != null) {
            return this.itemSource;
        }
        return SkinItemSource.EMPTY;
    }

    public void setRenderData(SkinRenderData renderData) {
        this.renderData = renderData;
    }

    public SkinRenderData getRenderData() {
        return this.renderData;
    }

    public void setPose(MatrixStack pose) {
        this.usingPoseStack.set(pose);
    }

    public void setBuffers(IRenderTypeBuffer buffers) {
        this.buffers = buffers;
    }

    public IRenderTypeBuffer getBuffers() {
        return this.buffers;
    }

    public SkinRenderBufferSource.ObjectBuilder getBuffer(@NotNull BakedSkin skin) {
        if (this.bufferProvider != null) {
            return this.bufferProvider.getBuffer(skin);
        }
        SkinVertexBufferBuilder bufferBuilder = SkinVertexBufferBuilder.getBuffer(this.buffers);
        return bufferBuilder.getBuffer(skin);
    }

    public void setBufferProvider(SkinRenderBufferSource bufferProvider) {
        this.bufferProvider = bufferProvider;
    }
}

