/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.client.model.IHumanoidModel;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.client.model.IPlayerModel;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.client.other.SkinOverriddenManager;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModDebugger;

public class SkinVisibilityTransformer<M extends IModel> {
    private final ArrayList<IModelPart> applying = new ArrayList();
    private final HashMap<ISkinProperty<Boolean>, Entry<M>> propertyActions = new HashMap();

    public static <M extends IHumanoidModel> void setupHumanoidModel(SkinVisibilityTransformer<M> transformer) {
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_HEAD, IHumanoidModel::getHeadPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_CHEST, IHumanoidModel::getBodyPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_LEFT_ARM, IHumanoidModel::getLeftArmPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, IHumanoidModel::getRightArmPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, IHumanoidModel::getLeftLegPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, IHumanoidModel::getRightLegPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_OVERLAY_HAT, IHumanoidModel::getHatPart);
    }

    public static <M extends IPlayerModel> void setupPlayerModel(SkinVisibilityTransformer<M> transformer) {
        transformer.linkToPart(SkinProperty.OVERRIDE_OVERLAY_HAT, IHumanoidModel::getHatPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_OVERLAY_HAT, IPlayerModel::getEarPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_OVERLAY_CLOAK, IPlayerModel::getCloakPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_OVERLAY_JACKET, IPlayerModel::getJacketPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, IPlayerModel::getLeftSleevePart);
        transformer.linkToPart(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, IPlayerModel::getRightSleevePart);
        transformer.linkToPart(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, IPlayerModel::getLeftPantsPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, IPlayerModel::getRightPantsPart);
    }

    public void linkToPart(ISkinProperty<Boolean> property, String name) {
        this.linkToPart(property, (M m) -> m.getPart(name));
    }

    public void linkToPart(ISkinProperty<Boolean> property, Function<M, IModelPart> applier) {
        this.propertyActions.computeIfAbsent(property, Entry::new).singles.add(applier);
    }

    public void linkToParts(ISkinProperty<Boolean> property, Function<M, Collection<IModelPart>> applier) {
        this.propertyActions.computeIfAbsent(property, Entry::new).multiples.add(applier);
    }

    public void willRender(M model, SkinOverriddenManager overriddenManager) {
        if (ModDebugger.modelOverride) {
            return;
        }
        this.applying.clear();
        this.propertyActions.forEach((property, entry) -> {
            if (overriddenManager.contains((ISkinProperty<Boolean>)property)) {
                ((Entry)entry).singles.forEach(it -> this.appendIfNeeded((IModelPart)it.apply(model)));
                ((Entry)entry).multiples.forEach(it -> ((Collection)it.apply(model)).forEach(this::appendIfNeeded));
            }
        });
    }

    public void didRender(M model, SkinOverriddenManager overriddenManager) {
        this.applying.forEach(it -> it.setVisible(true));
        this.applying.clear();
    }

    private void appendIfNeeded(IModelPart modelPart) {
        if (modelPart != null && modelPart.isVisible()) {
            this.applying.add(modelPart);
            modelPart.setVisible(false);
        }
    }

    public static class Entry<M extends IModel> {
        private final ArrayList<Function<M, IModelPart>> singles = new ArrayList();
        private final ArrayList<Function<M, Collection<IModelPart>>> multiples = new ArrayList();

        public Entry(ISkinProperty<Boolean> property) {
        }
    }
}

