/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other.thirdparty;

import java.util.Collection;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerKey;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.other.thirdparty.EpicFlightModelPart;
import moe.plushie.armourers_workshop.core.client.other.thirdparty.EpicFlightModelTransformer;
import moe.plushie.armourers_workshop.utils.DataStorageKey;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import net.minecraft.client.renderer.model.Model;
import org.jetbrains.annotations.Nullable;

public class EpicFlightModel
implements IModel {
    private static final DataStorageKey<EpicFlightModel> KEY = DataStorageKey.of("EpicFlightModel", EpicFlightModel.class);
    private final IModel parent;
    private final HashMap<String, EpicFlightModelPart> namedParts = new HashMap();
    private Object childRef;
    private IModel child;
    private boolean isValid = false;
    private BakedArmatureTransformer transformer;

    public EpicFlightModel(IModel parent) {
        this.parent = parent;
    }

    public static <V extends Model> EpicFlightModel ofNullable(V model) {
        Object model1 = ModelHolder.ofNullable(model);
        if (model1 == null) {
            return null;
        }
        EpicFlightModel model2 = model1.getAssociatedObject(KEY);
        if (model2 != null) {
            return model2;
        }
        model2 = new EpicFlightModel((IModel)model1);
        model1.setAssociatedObject((EpicFlightModel)model2, KEY);
        return model2;
    }

    public void linkTo(Object mesh) {
        if (this.childRef == mesh) {
            return;
        }
        this.childRef = mesh;
        this.child = EpicFlightModelTransformer.create(mesh);
        this.namedParts.forEach((key, value) -> value.linkTo(this.child.getPart((String)key)));
    }

    public void setTransformer(BakedArmatureTransformer transformer) {
        this.transformer = transformer;
    }

    public BakedArmatureTransformer getTransformer() {
        return this.transformer;
    }

    public void setInvalid(boolean valid) {
        this.isValid = valid;
    }

    public boolean isInvalid() {
        return this.isValid;
    }

    @Override
    @Nullable
    public IModelBabyPose getBabyPose() {
        return this.parent.getBabyPose();
    }

    @Override
    public IModelPart getPart(String name) {
        return this.namedParts.computeIfAbsent(name, it -> {
            IModelPart part = this.parent.getPart(name);
            return new EpicFlightModelPart(part);
        });
    }

    @Override
    public Collection<IModelPart> getAllParts() {
        return this.parent.getAllParts();
    }

    @Override
    public Class<?> getType() {
        return this.parent.getType();
    }

    @Override
    public <T> T getAssociatedObject(IAssociatedContainerKey<T> key) {
        return this.parent.getAssociatedObject(key);
    }

    @Override
    public <T> void setAssociatedObject(T value, IAssociatedContainerKey<T> key) {
        this.parent.setAssociatedObject(value, key);
    }
}

