/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other.thirdparty;

import com.mojang.blaze3d.matrix.MatrixStack;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightTransformProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.other.SkinOverriddenManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.thirdparty.EpicFlightModel;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager2;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.Entity;

public class EpicFlightRenderContext {
    public boolean isLimitLimbs = false;
    private boolean isActivate = false;
    private boolean isFirstPerson = false;
    private MatrixStack poseStack;
    private final EpicFlightModel model;
    private final SkinRenderContext context;
    private final BakedArmatureTransformer transformer;

    public EpicFlightRenderContext(EpicFlightModel model, SkinRenderContext context) {
        this.model = model;
        this.transformer = model.getTransformer();
        this.poseStack = context.pose().pose();
        this.context = context;
    }

    public static EpicFlightRenderContext of(Entity entity) {
        SkinRenderData renderData = SkinRenderData.of(entity);
        if (renderData != null) {
            return renderData.epicFlightContext;
        }
        return null;
    }

    public static EpicFlightRenderContext alloc(Entity entity, LivingRenderer<?, ?> entityRenderer, int light, float partialTick, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        EpicFlightRenderContext context1;
        SkinRenderData renderData = SkinRenderData.of(entity);
        EpicFlightModel model = EpicFlightModel.ofNullable(entityRenderer.func_217764_d());
        if (renderData == null || model == null || model.isInvalid()) {
            return null;
        }
        if (model.getTransformer() == null) {
            ArmatureTransformer transformer = SkinRendererManager2.EPICFIGHT.getTransformer(entity.func_200600_R(), model);
            model.setTransformer(BakedArmatureTransformer.create(transformer, entityRenderer));
        }
        if (model.getTransformer() == null) {
            model.setInvalid(true);
            return null;
        }
        SkinRenderContext context = SkinRenderContext.alloc(renderData, light, partialTick, AbstractItemTransformType.NONE, poseStack, buffers);
        renderData.epicFlightContext = context1 = new EpicFlightRenderContext(model, context);
        return context1;
    }

    public static void release(Entity entity) {
        SkinRenderData renderData = SkinRenderData.of(entity);
        if (renderData != null) {
            EpicFlightRenderContext context = renderData.epicFlightContext;
            context.transformer.setFilter(null);
            context.context.release();
            renderData.epicFlightContext = null;
        }
    }

    public void prepare(Entity entity) {
        this.transformer.prepare(entity, this.context);
    }

    public void activate(Entity entity) {
        this.transformer.activate(entity, this.context);
        this.isActivate = true;
    }

    public void deactivate(Entity entity) {
        if (this.isActivate) {
            this.transformer.deactivate(entity, this.context);
            this.isActivate = false;
        }
    }

    public void setMesh(Object mesh) {
        this.model.linkTo(mesh);
    }

    public void setTransformProvider(EpicFlightTransformProvider transformProvider) {
        this.model.setAssociatedObject(transformProvider, EpicFlightTransformProvider.KEY);
    }

    public void setFirstPerson(boolean isFirstPerson) {
        this.isFirstPerson = isFirstPerson;
        if (isFirstPerson) {
            this.transformer.setFilter(joint -> !joint.getName().equals("Head") && !joint.getName().equals("Chest") && !joint.getName().equals("Torso"));
        } else {
            this.transformer.setFilter(null);
        }
    }

    public boolean isFirstPerson() {
        return this.isFirstPerson;
    }

    public EpicFlightModel getModel() {
        return this.model;
    }

    public BakedArmatureTransformer getTransformer() {
        return this.transformer;
    }

    public SkinOverriddenManager getOverriddenManager() {
        return this.context.getRenderData().getOverriddenManager();
    }

    public void setPose(MatrixStack poseStack) {
        this.poseStack = poseStack;
    }

    public MatrixStack getPose() {
        return this.poseStack;
    }
}

