/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class ExtendedItemRenderer {
    public static void renderSkinInGUI(BakedSkin bakedSkin, float x, float y, float z, float width, float height, float rx, float ry, float rz, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, ColorScheme.EMPTY, ItemStack.field_190927_a, ExtendedItemRenderer.getTarget(bakedSkin), x, y, z, width, height, rx, ry, rz, 0.0f, 0xF000F0, poseStack, buffers);
    }

    public static void renderSkinInGUI(BakedSkin bakedSkin, ColorScheme scheme, ItemStack itemStack, float x, float y, float z, float width, float height, float rx, float ry, float rz, float partialTicks, int light, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, itemStack, null, x, y, z, width, height, rx, ry, rz, partialTicks, light, poseStack, buffers);
    }

    public static void renderSkinInTooltip(BakedSkin bakedSkin, ColorScheme scheme, ItemStack itemStack, float x, float y, float z, float width, float height, float rx, float ry, float rz, float partialTicks, int light, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, itemStack, Vector3f.ONE, x, y, z, width, height, rx, ry, rz, partialTicks, light, poseStack, buffers);
    }

    public static int renderSkinInBox(BakedSkin bakedSkin, ColorScheme scheme, Vector3f scale, float partialTicks, int light, SkinItemSource itemSource, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        return ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, scale, ExtendedItemRenderer.getTarget(bakedSkin), partialTicks, light, itemSource, poseStack, buffers);
    }

    private static void renderSkinInBox(BakedSkin bakedSkin, ColorScheme scheme, ItemStack itemStack, @Nullable Vector3f target, float x, float y, float z, float width, float height, float rx, float ry, float rz, float partialTicks, int light, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        if (bakedSkin != null) {
            int t = TickUtils.ticks();
            float si = Math.min(width, height);
            poseStack.func_227860_a_();
            poseStack.func_227861_a_((double)(x + width / 2.0f), (double)(y + height / 2.0f), (double)z);
            ABI.mulPoseMatrix(poseStack, OpenMatrix4f.createScaleMatrix(1.0f, -1.0f, 1.0f));
            ABI.mulNormalMatrix(poseStack, OpenMatrix3f.createScaleMatrix(1.0f, -1.0f, 1.0f));
            ABI.mulPose(poseStack, Vector3f.XP.rotationDegrees(rx));
            ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(ry + (float)(t / 10 % 360)));
            poseStack.func_227862_a_(0.625f, 0.625f, 0.625f);
            poseStack.func_227862_a_(si, si, si);
            ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, Vector3f.ONE, target, partialTicks, light, SkinItemSource.create(itemStack), poseStack, buffers);
            poseStack.func_227865_b_();
        }
    }

    private static int renderSkinInBox(BakedSkin bakedSkin, ColorScheme scheme, Vector3f scale, @Nullable Vector3f target, float partialTicks, int light, SkinItemSource itemSource, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        int counter = 0;
        SkinRenderTesselator context = SkinRenderTesselator.create(bakedSkin);
        if (context == null) {
            return counter;
        }
        poseStack.func_227860_a_();
        poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        context.setLightmap(light);
        context.setPartialTicks(partialTicks);
        context.setRenderData(SkinRenderData.of((Entity)context.getMannequin()));
        context.setColorScheme(scheme);
        context.setReferenced(itemSource);
        if (target != null) {
            Rectangle3f rect = context.getBakedRenderBounds();
            float targetWidth = target.getX();
            float targetHeight = target.getY();
            float targetDepth = target.getZ();
            float newScale = Math.min(targetWidth / rect.getWidth(), targetHeight / rect.getHeight());
            newScale = Math.min(newScale, targetDepth / rect.getDepth());
            if (ModDebugger.targetBounds) {
                ShapeTesselator.stroke(-targetWidth / 2.0f, -targetHeight / 2.0f, -targetDepth / 2.0f, targetWidth / 2.0f, targetHeight / 2.0f, targetDepth / 2.0f, UIColor.ORANGE, poseStack, buffers);
                ShapeTesselator.vector(0.0f, 0.0f, 0.0f, targetWidth, targetHeight, targetDepth, poseStack, buffers);
            }
            poseStack.func_227862_a_(newScale / scale.getX(), newScale / scale.getY(), newScale / scale.getZ());
            poseStack.func_227861_a_((double)(-rect.getMidX()), (double)(-rect.getMidY()), (double)(-rect.getMidZ()));
        } else {
            float newScale = 0.0625f;
            poseStack.func_227862_a_(newScale, newScale, newScale);
        }
        counter = context.draw(poseStack, buffers);
        poseStack.func_227865_b_();
        return counter;
    }

    public static void renderMannequin(PlayerTextureDescriptor descriptor, Vector3f rotation, Vector3f scale, float targetWidth, float targetHeight, float targetDepth, float partialTicks, int light, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        MannequinEntity entity = PlaceholderManager.MANNEQUIN.get();
        if (entity == null || PropertyProvider.getLevel((Entity)entity) == null) {
            return;
        }
        poseStack.func_227860_a_();
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(180.0f));
        if (!descriptor.equals(entity.getTextureDescriptor())) {
            entity.setTextureDescriptor(descriptor);
        }
        Rectangle3f rect = new Rectangle3f(entity.func_174813_aQ());
        if (ModDebugger.targetBounds) {
            ShapeTesselator.stroke(-targetWidth / 2.0f, -targetHeight / 2.0f, -targetDepth / 2.0f, targetWidth / 2.0f, targetHeight / 2.0f, targetDepth / 2.0f, UIColor.ORANGE, poseStack, buffers);
            ShapeTesselator.vector(0.0f, 0.0f, 0.0f, targetWidth, targetHeight, targetDepth, poseStack, buffers);
        }
        Rectangle3f resolvedRect = rect.offset(rect.getMidX(), rect.getMidY(), rect.getMidZ());
        resolvedRect.mul(new OpenMatrix4f(new OpenQuaternionf(rotation.getX(), rotation.getY(), rotation.getZ(), true)));
        float newScale = Math.min(targetWidth / resolvedRect.getWidth(), targetHeight / resolvedRect.getHeight());
        poseStack.func_227862_a_(newScale, newScale, newScale);
        poseStack.func_227861_a_((double)(-rect.getMidX()), (double)(-rect.getMidY()), (double)(-rect.getMidZ()));
        EntityRendererManager rendererManager = Minecraft.func_71410_x().func_175598_ae();
        RenderSystem.runAsFancy(() -> rendererManager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, buffers, light));
        poseStack.func_227865_b_();
    }

    private static Vector3f getTarget(BakedSkin bakedSkin) {
        if (bakedSkin != null && bakedSkin.getItemModel() == null) {
            return Vector3f.ONE;
        }
        return null;
    }
}

