/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinnableBlockRenderer<T extends SkinnableBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private final BakedArmature armature = new BakedArmature(Armatures.ANY);
    private final Supplier<MannequinEntity> placeholder = PlaceholderManager.MANNEQUIN;

    public SkinnableBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public void render(T entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int light, int overlay) {
        SkinDescriptor descriptor = ((SkinnableBlockEntity)entity).getDescriptor();
        BakedSkin skin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.RENDERER);
        if (skin == null) {
            return;
        }
        float f = 0.0625f;
        BlockState blockState = entity.func_195044_w();
        OpenQuaternionf rotations = ((SkinnableBlockEntity)entity).getRenderRotations(blockState);
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.5, 0.5, 0.5);
        ABI.mulPose(poseStack, rotations);
        poseStack.func_227862_a_(f, f, f);
        poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        SkinRenderContext context = SkinRenderContext.alloc(null, light, TickUtils.ticks(), poseStack, buffers);
        SkinRenderer.render((Entity)this.placeholder.get(), this.armature, skin, descriptor.getColorScheme(), context);
        context.release();
        poseStack.func_227865_b_();
        if (ModDebugger.skinnable) {
            skin.getBlockBounds().forEach((pos, rect) -> {
                poseStack.func_227860_a_();
                poseStack.func_227861_a_(0.5, 0.5, 0.5);
                poseStack.func_227862_a_(f, f, f);
                ABI.mulPose(poseStack, rotations);
                poseStack.func_227861_a_((double)((float)pos.func_177958_n() * 16.0f), (double)((float)pos.func_177956_o() * 16.0f), (double)((float)pos.func_177952_p() * 16.0f));
                ShapeTesselator.stroke(rect, UIColor.RED, poseStack, buffers);
                poseStack.func_227865_b_();
            });
            BlockPos pos2 = entity.func_174877_v();
            poseStack.func_227860_a_();
            poseStack.func_227861_a_((double)(-pos2.func_177958_n()), (double)(-pos2.func_177956_o()), (double)(-pos2.func_177952_p()));
            ShapeTesselator.stroke(((RotableContainerBlockEntity)entity).getCustomRenderBoundingBox(blockState), UIColor.ORANGE, poseStack, buffers);
            poseStack.func_227865_b_();
        }
    }
}

