/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.entity.Entity;

public class SkinRenderer {
    public static int render(Entity entity, BakedArmature armature, BakedSkin bakedSkin, ColorScheme scheme, SkinRenderContext context) {
        int counter = 0;
        ColorScheme scheme1 = bakedSkin.resolve(entity, scheme);
        SkinRenderBufferSource.ObjectBuilder builder = context.getBuffer(bakedSkin);
        for (BakedSkinPart bakedPart : bakedSkin.getParts()) {
            IJointTransform bakedTransform = armature.getTransform(bakedPart);
            if (bakedTransform == null) continue;
            boolean shouldRenderPart = SkinRenderer.shouldRenderPart(entity, bakedPart, bakedSkin, context);
            context.pushPose();
            bakedTransform.apply(context.pose());
            bakedPart.getTransform().apply(context.pose());
            builder.addPart(bakedPart, bakedSkin, scheme1, shouldRenderPart, context);
            SkinRenderer.renderChild(entity, bakedPart, bakedSkin, scheme1, shouldRenderPart, builder, context);
            SkinRenderer.renderDebugger(entity, bakedPart, bakedSkin, scheme1, shouldRenderPart, builder, context);
            if (shouldRenderPart) {
                ++counter;
            }
            context.popPose();
        }
        if (ModDebugger.skinBounds) {
            builder.addShape(bakedSkin.getRenderShape(entity, armature, context.getReferenced()), UIColor.RED, context);
        }
        if (ModDebugger.skinOrigin) {
            builder.addShape(Vector3f.ZERO, context);
        }
        if (ModDebugger.armature) {
            builder.addShape(armature, context);
        }
        return counter;
    }

    private static void renderChild(Entity entity, BakedSkinPart parentPart, BakedSkin bakedSkin, ColorScheme scheme, boolean shouldRenderPart, SkinRenderBufferSource.ObjectBuilder builder, SkinRenderContext context) {
        for (BakedSkinPart bakedPart : parentPart.getChildren()) {
            context.pushPose();
            bakedPart.getTransform().apply(context.pose());
            builder.addPart(bakedPart, bakedSkin, scheme, shouldRenderPart, context);
            SkinRenderer.renderChild(entity, bakedPart, bakedSkin, scheme, shouldRenderPart, builder, context);
            SkinRenderer.renderDebugger(entity, bakedPart, bakedSkin, scheme, shouldRenderPart, builder, context);
            context.popPose();
        }
    }

    private static void renderDebugger(Entity entity, BakedSkinPart bakedPart, BakedSkin bakedSkin, ColorScheme scheme, boolean shouldRenderPart, SkinRenderBufferSource.ObjectBuilder builder, SkinRenderContext context) {
        if (!shouldRenderPart) {
            return;
        }
        if (ModDebugger.skinPartBounds) {
            builder.addShape(bakedPart.getRenderShape(), ColorUtils.getPaletteColor(bakedPart.getId()), context);
        }
        if (ModDebugger.skinPartOrigin) {
            builder.addShape(Vector3f.ZERO, context);
        }
    }

    public static OpenVoxelShape getShape(Entity entity, BakedArmature armature, BakedSkin bakedSkin, SkinRenderContext context) {
        OpenVoxelShape voxelShape = OpenVoxelShape.empty();
        for (BakedSkinPart bakedPart : bakedSkin.getParts()) {
            SkinRenderer.getShape(entity, voxelShape, bakedPart, bakedSkin, armature, context);
        }
        return voxelShape;
    }

    private static void getShape(Entity entity, OpenVoxelShape shape, BakedSkinPart bakedPart, BakedSkin bakedSkin, BakedArmature armature, SkinRenderContext context) {
        if (!SkinRenderer.shouldRenderPart(entity, bakedPart, bakedSkin, context)) {
            return;
        }
        IJointTransform bakedTransform = armature.getTransform(bakedPart);
        if (bakedTransform == null) {
            return;
        }
        OpenVoxelShape shape1 = bakedPart.getRenderShape().copy();
        context.pushPose();
        bakedTransform.apply(context.pose());
        bakedPart.getTransform().apply(context.pose());
        shape1.mul(context.pose().lastPose());
        shape.add(shape1);
        for (BakedSkinPart childPart : bakedPart.getChildren()) {
            SkinRenderer.getChildShape(shape, childPart, context);
        }
        context.popPose();
    }

    private static void getChildShape(OpenVoxelShape shape, BakedSkinPart bakedPart, SkinRenderContext context) {
        OpenVoxelShape shape1 = bakedPart.getRenderShape().copy();
        context.pushPose();
        bakedPart.getTransform().apply(context.pose());
        shape1.mul(context.pose().lastPose());
        shape.add(shape1);
        for (BakedSkinPart childPart : bakedPart.getChildren()) {
            SkinRenderer.getChildShape(shape, childPart, context);
        }
        context.popPose();
    }

    private static boolean shouldRenderPart(Entity entity, BakedSkinPart bakedPart, BakedSkin bakedSkin, SkinRenderContext context) {
        return bakedSkin.shouldRenderPart(entity, bakedPart, context);
    }
}

