/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import java.util.HashMap;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.layer.SkinWardrobeLayer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkinRendererManager {
    private static final SkinRendererManager INSTANCE = new SkinRendererManager();
    private boolean isReady = false;
    private final HashMap<IEntityTypeProvider<?>, EntityProfile> entities = new HashMap();

    public static SkinRendererManager getInstance() {
        return INSTANCE;
    }

    public void reload() {
        EntityRendererManager entityRenderManager = Minecraft.func_71410_x().func_175598_ae();
        if (entityRenderManager == null) {
            RenderSystem.recordRenderCall(this::reload);
            return;
        }
        RenderSystem.recordRenderCall(() -> this._reload(entityRenderManager));
    }

    private void _reload(EntityRendererManager entityRenderManager) {
        SkinRendererManager skinRendererManager = SkinRendererManager.getInstance();
        for (EntityRenderer renderer : entityRenderManager.field_178636_l.values()) {
            if (!(renderer instanceof LivingRenderer)) continue;
            skinRendererManager.setupRenderer(EntityType.field_200729_aH, (LivingRenderer)renderer, true);
        }
        entityRenderManager.field_78729_o.forEach((entityType1, entityRenderer) -> {
            if (entityRenderer instanceof LivingRenderer) {
                skinRendererManager.setupRenderer((EntityType<?>)entityType1, (LivingRenderer)((LivingRenderer)entityRenderer), true);
            }
        });
        this.entities.forEach(this::_bind);
        this.isReady = true;
    }

    public void unbind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        ModLog.debug("Detach Entity Renderer '{}'", entityType.getRegistryName());
        this.entities.remove(entityType);
        if (this.isReady) {
            // empty if block
        }
    }

    public void bind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        ModLog.debug("Attach Entity Renderer '{}'", entityType.getRegistryName());
        this.entities.put(entityType, entityProfile);
        if (this.isReady) {
            this._bind(entityType, entityProfile);
        }
    }

    private void _bind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        EntityType resolvedEntityType = (EntityType)entityType.get();
        if (resolvedEntityType == null) {
            return;
        }
        EntityRendererManager entityRenderManager = Minecraft.func_71410_x().func_175598_ae();
        if (entityRenderManager == null) {
            return;
        }
        if (resolvedEntityType == EntityType.field_200729_aH) {
            for (EntityRenderer renderer2 : entityRenderManager.field_178636_l.values()) {
                if (!(renderer2 instanceof LivingRenderer)) continue;
                this.setupRenderer(resolvedEntityType, (LivingRenderer)renderer2, false);
            }
        }
        entityRenderManager.field_78729_o.forEach((entityType1, renderer) -> {
            if (resolvedEntityType.equals(entityType1) && renderer instanceof LivingRenderer) {
                this.setupRenderer(resolvedEntityType, (LivingRenderer)renderer, false);
            }
        });
    }

    private <T extends LivingEntity, V extends EntityModel<T>> void setupRenderer(EntityType<?> entityType, LivingRenderer<T, V> livingRenderer, boolean autoInject) {
        LayerRenderer armorLayer = null;
        for (LayerRenderer layerRenderer : livingRenderer.field_177097_h) {
            if (layerRenderer instanceof BipedArmorLayer) {
                armorLayer = layerRenderer;
            }
            if (!(layerRenderer instanceof SkinWardrobeLayer)) continue;
            return;
        }
        if (autoInject && armorLayer == null) {
            return;
        }
        BakedArmatureTransformer transformer = BakedArmatureTransformer.defaultBy(entityType, (Model)livingRenderer.func_217764_d(), livingRenderer);
        if (transformer != null) {
            livingRenderer.func_177094_a(new SkinWardrobeLayer(transformer, livingRenderer));
        }
    }

    public void willRender(Entity entity, Model entityModel, @Nullable EntityRenderer<?> entityRenderer, SkinRenderData renderData, Supplier<SkinRenderContext> context) {
        BakedArmatureTransformer transformer = BakedArmatureTransformer.defaultBy(entity, entityModel, entityRenderer);
        if (transformer != null) {
            SkinRenderContext context1 = context.get();
            transformer.prepare(entity, context1);
            context1.release();
        }
    }

    public void willRenderModel(Entity entity, Model entityModel, @Nullable EntityRenderer<?> entityRenderer, SkinRenderData renderData, Supplier<SkinRenderContext> context) {
        BakedArmatureTransformer transformer = BakedArmatureTransformer.defaultBy(entity, entityModel, entityRenderer);
        if (transformer != null) {
            SkinRenderContext context1 = context.get();
            transformer.activate(entity, context1);
            context1.release();
        }
    }

    public void didRender(Entity entity, Model entityModel, @Nullable EntityRenderer<?> entityRenderer, SkinRenderData renderData, Supplier<SkinRenderContext> context) {
        BakedArmatureTransformer transformer = BakedArmatureTransformer.defaultBy(entity, entityModel, entityRenderer);
        if (transformer != null) {
            SkinRenderContext context1 = context.get();
            transformer.deactivate(entity, context1);
            context1.release();
        }
    }
}

