/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.data.IDataPackBuilder;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractSkinnableModels;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.armature.core.DefaultArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import net.minecraft.util.ResourceLocation;

public class SkinRendererManager2 {
    public static final HashMap<ResourceLocation, Class<?>> NAMED_CLASSES = new HashMap();
    public static final ArmatureTransformerManager DEFAULT = new DefaultArmatureTransformerManager();
    public static final ArmatureTransformerManager EPICFIGHT = new EpicFlightArmatureTransformerManager();
    private static final ImmutableMap<String, ArmatureTransformerManager> MANAGERS = ImmutableMap.builder().put((Object)"armourers_workshop:armature", (Object)DEFAULT).put((Object)"epicfight:armature", (Object)EPICFIGHT).build();

    public static void init() {
        Armatures.init();
        SkinRendererManager2.registerAll();
        DataPackManager.register(DataPackType.BUNDLED_DATA, "skin/transformers", SimpleLoader::new, SimpleLoader::clean, SimpleLoader::freeze, 0);
    }

    private static void register(String name, Class<?> clazz) {
        NAMED_CLASSES.put(new ResourceLocation("minecraft", name), clazz);
    }

    private static void registerAll() {
        SkinRendererManager2.register("model/illager", AbstractSkinnableModels.ILLAGER);
        SkinRendererManager2.register("model/zombie_villager", AbstractSkinnableModels.ZOMBIE_VILLAGER);
        SkinRendererManager2.register("model/villager", AbstractSkinnableModels.VILLAGER);
        SkinRendererManager2.register("model/iron_golem", AbstractSkinnableModels.IRON_GOLEM);
        SkinRendererManager2.register("model/enderman", AbstractSkinnableModels.ENDERMAN);
        SkinRendererManager2.register("model/player", AbstractSkinnableModels.PLAYER);
        SkinRendererManager2.register("model/humanoid", AbstractSkinnableModels.HUMANOID);
        SkinRendererManager2.register("model/slime", AbstractSkinnableModels.SLIME);
        SkinRendererManager2.register("model/ghast", AbstractSkinnableModels.GHAST);
        SkinRendererManager2.register("model/chicken", AbstractSkinnableModels.CHICKEN);
        SkinRendererManager2.register("model/creeper", AbstractSkinnableModels.CREEPER);
        SkinRendererManager2.register("model/horse", AbstractSkinnableModels.HORSE);
        SkinRendererManager2.register("model/boat", AbstractSkinnableModels.BOAT);
        SkinRendererManager2.register("model/raft", AbstractSkinnableModels.RAFT);
        SkinRendererManager2.register("model/allay", AbstractSkinnableModels.ALLAY);
    }

    public static class SimpleLoader
    implements IDataPackBuilder {
        private final ResourceLocation location;

        public SimpleLoader(ResourceLocation location) {
            this.location = location;
        }

        @Override
        public void append(IDataPackObject object, ResourceLocation file) {
            String type = object.get("type").stringValue();
            ArmatureTransformerManager manager = (ArmatureTransformerManager)MANAGERS.get((Object)type);
            if (manager != null) {
                manager.append(object, this.location);
            }
        }

        @Override
        public void build() {
        }

        public static void clean() {
            MANAGERS.values().forEach(ArmatureTransformerManager::clear);
        }

        public static void freeze() {
            MANAGERS.values().forEach(ArmatureTransformerManager::freeze);
        }
    }
}

