/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.Optional;
import moe.plushie.armourers_workshop.api.common.ICapabilityType;
import moe.plushie.armourers_workshop.api.data.IAssociatedObjectProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.init.ModCapabilities;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.utils.LazyOptional;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkinDataStorage {
    protected LazyOptional<SkinWardrobe> wardrobe;
    protected LazyOptional<SkinRenderData> renderData;
    protected int lastWardrobeTickCount = Integer.MAX_VALUE;
    protected int lastRenderDataTickCount = Integer.MAX_VALUE;

    public SkinDataStorage(Entity entity) {
        this.wardrobe = SkinDataStorage.getLazyWardrobe(entity);
        this.renderData = SkinDataStorage.getLazyRenderData(entity);
    }

    public static Optional<SkinWardrobe> getWardrobe(Entity entity) {
        SkinDataStorage storage = SkinDataStorage.getDataStore(entity);
        if (storage.wardrobe != null) {
            return storage.wardrobe.resolve();
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<SkinRenderData> getRenderData(Entity entity) {
        SkinDataStorage storage = SkinDataStorage.getDataStore(entity);
        if (storage.renderData == null) {
            return Optional.empty();
        }
        Optional<SkinRenderData> renderData = storage.renderData.resolve();
        renderData.ifPresent(data -> {
            int tickCount = entity.field_70173_aa;
            if (storage.lastRenderDataTickCount != tickCount) {
                storage.lastRenderDataTickCount = tickCount;
                data.tick(entity);
            }
        });
        return renderData;
    }

    private static SkinDataStorage getDataStore(Entity entity) {
        IAssociatedObjectProvider provider = (IAssociatedObjectProvider)entity;
        SkinDataStorage snapshot = (SkinDataStorage)provider.getAssociatedObject();
        if (snapshot == null) {
            snapshot = new SkinDataStorage(entity);
            provider.setAssociatedObject(snapshot);
        }
        return snapshot;
    }

    private static LazyOptional<SkinWardrobe> getLazyWardrobe(Entity entity) {
        Optional wardrobe = ((ICapabilityType)ModCapabilities.WARDROBE.get()).get(entity);
        if (wardrobe.isPresent()) {
            return LazyOptional.of(wardrobe::get);
        }
        return LazyOptional.empty();
    }

    private static LazyOptional<SkinRenderData> getLazyRenderData(Entity entity) {
        Optional renderData = EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> new SkinRenderData(entity.func_200600_R()));
        if (renderData.isPresent()) {
            return LazyOptional.of(renderData::get);
        }
        return LazyOptional.empty();
    }
}

