/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.slot;

import moe.plushie.armourers_workshop.api.common.IItemTag;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModItemMatchers;
import moe.plushie.armourers_workshop.init.ModItemTags;
import moe.plushie.armourers_workshop.init.platform.RegistryManager;
import moe.plushie.armourers_workshop.utils.ItemMatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum ItemOverrideType {
    SWORD("sword", ModItemTags.SWORDS, ModItemMatchers.SWORDS),
    SHIELD("shield", ModItemTags.SHIELDS, ModItemMatchers.SHIELDS),
    BOW("bow", ModItemTags.BOWS, ModItemMatchers.BOWS),
    TRIDENT("trident", ModItemTags.TRIDENTS, ModItemMatchers.TRIDENTS),
    PICKAXE("pickaxe", ModItemTags.PICKAXES, ModItemMatchers.PICKAXES),
    AXE("axe", ModItemTags.AXES, ModItemMatchers.AXES),
    SHOVEL("shovel", ModItemTags.SHOVELS, ModItemMatchers.SHOVELS),
    HOE("hoe", ModItemTags.HOES, ModItemMatchers.HOES),
    BOAT("boat", ModItemTags.BOATS, ModItemMatchers.BOATS),
    FISHING_ROD("fishing_rod", ModItemTags.FISHING_RODS, ModItemMatchers.FISHING_RODS),
    ITEM("item", null, null);

    private final IRegistryKey<IItemTag> tag;
    private final String name;
    private final ItemMatcher matcher;

    private ItemOverrideType(String name, IRegistryKey<IItemTag> tag, ItemMatcher matcher) {
        this.name = name;
        this.tag = tag;
        this.matcher = matcher;
    }

    @Nullable
    public static ItemOverrideType of(String name) {
        for (ItemOverrideType overrideType : ItemOverrideType.values()) {
            if (!overrideType.getName().equals(name)) continue;
            return overrideType;
        }
        return null;
    }

    public boolean isOverrideItem(ItemStack itemStack) {
        if (this == ITEM) {
            return true;
        }
        ResourceLocation registryName = RegistryManager.getKey(itemStack.func_77973_b());
        if (ModConfig.Common.overrides.contains(this.name + ":" + registryName)) {
            return true;
        }
        if (this.tag != null && ((IItemTag)this.tag.get()).contains(itemStack)) {
            return true;
        }
        return this.matcher.test(registryName, itemStack);
    }

    public String getName() {
        return this.name;
    }
}

