/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.action.ICanRotation;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinWingsTransform;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;

public class SkinPartTransform
implements ISkinTransform {
    private final ArrayList<ISkinTransform> transforms = new ArrayList();

    public SkinPartTransform(SkinPart part, ISkinTransform quadsTransform) {
        ISkinTransform partTransform;
        ISkinTransform wingsTransform;
        if (quadsTransform != null) {
            this.transforms.add(quadsTransform);
        }
        if ((wingsTransform = this.getWingsTransform(part)) != null) {
            this.transforms.add(wingsTransform);
        }
        if ((partTransform = part.getTransform()) != null) {
            this.transforms.add(partTransform);
        }
    }

    public void forEach(Consumer<ISkinTransform> consumer) {
        this.transforms.forEach(consumer);
    }

    private ISkinTransform getWingsTransform(SkinPart part) {
        ISkinPartType partType = part.getType();
        if (!(partType instanceof ICanRotation)) {
            return null;
        }
        Collection<SkinMarker> markers = part.getMarkers();
        if (markers == null || markers.size() == 0) {
            return null;
        }
        return new SkinWingsTransform(partType, part.getProperties(), markers.iterator().next());
    }

    @Override
    public void apply(IPoseStack poseStack) {
        for (ISkinTransform transform : this.transforms) {
            transform.apply(poseStack);
        }
    }

    public void addTransform(ISkinTransform transform) {
        this.transforms.add(transform);
    }

    public void insertTransform(ISkinTransform transform, int index) {
        this.transforms.add(index, transform);
    }

    public void removeTransform(ISkinTransform transform) {
        this.transforms.remove(transform);
    }
}

