/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import extensions.net.minecraft.world.entity.player.Player.PropertyProvider;
import extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import java.util.List;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.common.IItemGroupProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.core.holiday.Holiday;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.init.ModHolidays;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class GiftSackItem
extends FlavouredItem
implements IItemGroupProvider,
IItemTintColorProvider {
    public GiftSackItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack of(Holiday holiday) {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.GIFT_SACK.get());
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a("Holiday", holiday.getName());
        if (holiday.getHandler() != null) {
            nbt.func_74768_a("Color1", holiday.getHandler().getBackgroundColor());
            nbt.func_74768_a("Color2", holiday.getHandler().getForegroundColor());
        }
        return stack;
    }

    public static ItemStack getGift(ItemStack itemStack, PlayerEntity player) {
        Holiday holiday = GiftSackItem.getHoliday(itemStack);
        if (holiday != null && holiday.getHandler() != null) {
            return holiday.getHandler().getGift(player);
        }
        CompoundNBT itemNBT = itemStack.func_179543_a("Gift");
        if (itemNBT != null) {
            return ItemStack.func_199557_a((CompoundNBT)itemNBT);
        }
        return ItemStack.field_190927_a;
    }

    public static Holiday getHoliday(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_77978_p();
        if (nbt != null) {
            return ModHolidays.byName(nbt.func_74779_i("Holiday"));
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        ItemStack giftStack = GiftSackItem.getGift(itemStack, player);
        if (giftStack.func_190926_b()) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        if (!level.func_201670_d()) {
            if (PropertyProvider.getInventory(player).func_70441_a(giftStack)) {
                itemStack.func_190918_g(1);
            } else {
                SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.inventoryFull", new Object[0]));
            }
        }
        return ActionResult.func_233538_a_((Object)itemStack, (boolean)level.func_201670_d());
    }

    @Override
    public void fillItemGroup(List<ItemStack> results, IItemGroup group) {
        for (Holiday holiday : ModHolidays.getHolidays()) {
            if (holiday.getHandler() == null) continue;
            results.add(GiftSackItem.of(holiday));
        }
    }

    @Override
    public int getTintColor(ItemStack itemStack, int index) {
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag == null) {
            return -1;
        }
        if (index == 1) {
            return OptionalAPI.getOptionalInt(tag, "Color2", 0x333333) | 0xFF000000;
        }
        return OptionalAPI.getOptionalInt(tag, "Color1", 0xFFFFFF) | 0xFF000000;
    }
}

