/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;

public class SkinDocumentTypes {
    private static final LinkedHashMap<String, SkinDocumentType> ALL_TYPES = new LinkedHashMap();
    public static final SkinDocumentType GENERAL_ARMOR_HEAD = SkinDocumentTypes.register("general", SkinTypes.ARMOR_HEAD);
    public static final SkinDocumentType GENERAL_ARMOR_CHEST = SkinDocumentTypes.register("general", SkinTypes.ARMOR_CHEST);
    public static final SkinDocumentType GENERAL_ARMOR_FEET = SkinDocumentTypes.register("general", SkinTypes.ARMOR_FEET);
    public static final SkinDocumentType GENERAL_ARMOR_LEGS = SkinDocumentTypes.register("general", SkinTypes.ARMOR_LEGS);
    public static final SkinDocumentType GENERAL_ARMOR_WINGS = SkinDocumentTypes.register("general", SkinTypes.ARMOR_WINGS);
    public static final SkinDocumentType GENERAL_ARMOR_OUTFIT = SkinDocumentTypes.register("general", SkinTypes.OUTFIT);
    public static final SkinDocumentType ITEM = SkinDocumentTypes.register("item", SkinTypes.ITEM);
    public static final SkinDocumentType ITEM_SWORD = SkinDocumentTypes.register("item", SkinTypes.ITEM_SWORD);
    public static final SkinDocumentType ITEM_SHIELD = SkinDocumentTypes.register("item", SkinTypes.ITEM_SHIELD);
    public static final SkinDocumentType ITEM_BOW = SkinDocumentTypes.register("item", SkinTypes.ITEM_BOW);
    public static final SkinDocumentType ITEM_TRIDENT = SkinDocumentTypes.register("item", SkinTypes.ITEM_TRIDENT);
    public static final SkinDocumentType ITEM_PICKAXE = SkinDocumentTypes.register("item", SkinTypes.ITEM_PICKAXE);
    public static final SkinDocumentType ITEM_AXE = SkinDocumentTypes.register("item", SkinTypes.ITEM_AXE);
    public static final SkinDocumentType ITEM_SHOVEL = SkinDocumentTypes.register("item", SkinTypes.ITEM_SHOVEL);
    public static final SkinDocumentType ITEM_HOE = SkinDocumentTypes.register("item", SkinTypes.ITEM_HOE);
    public static final SkinDocumentType ITEM_BOAT = SkinDocumentTypes.register("item", SkinTypes.ITEM_BOAT);
    public static final SkinDocumentType ITEM_FISHING = SkinDocumentTypes.register("item", SkinTypes.ITEM_FISHING);
    public static final SkinDocumentType ENTITY_HORSE = SkinDocumentTypes.register("entity", SkinTypes.HORSE);
    public static final SkinDocumentType BLOCK = SkinDocumentTypes.register("block", SkinTypes.BLOCK);

    public static SkinDocumentType byName(String name) {
        return ALL_TYPES.getOrDefault(name, GENERAL_ARMOR_HEAD);
    }

    public static void forEach(BiConsumer<String, List<SkinDocumentType>> consumer) {
        ArrayList names = new ArrayList();
        HashMap sections = new HashMap();
        Function<String, List> builder = name -> {
            names.add(name);
            return new ArrayList();
        };
        ALL_TYPES.forEach((key, it) -> ((List)sections.computeIfAbsent(it.getName(), builder)).add(it));
        for (String name2 : names) {
            consumer.accept(name2, (List)sections.get(name2));
        }
    }

    private static SkinDocumentType register(String category, ISkinType skinType) {
        SkinDocumentType advancedSkinType = new SkinDocumentType(category, skinType);
        advancedSkinType.setRegistryName(skinType.getRegistryName());
        ALL_TYPES.put(advancedSkinType.getRegistryName().toString(), advancedSkinType);
        return advancedSkinType;
    }
}

