/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.part;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.advanced.AdvancedPartType;
import moe.plushie.armourers_workshop.core.skin.part.block.BlockPartType;
import moe.plushie.armourers_workshop.core.skin.part.block.MultiBlockPartType;
import moe.plushie.armourers_workshop.core.skin.part.bow.ArrowPartType;
import moe.plushie.armourers_workshop.core.skin.part.bow.BowPartType;
import moe.plushie.armourers_workshop.core.skin.part.chest.ChestPartType;
import moe.plushie.armourers_workshop.core.skin.part.chest.LeftArmPartType;
import moe.plushie.armourers_workshop.core.skin.part.chest.RightArmPartType;
import moe.plushie.armourers_workshop.core.skin.part.feet.LeftFootPartType;
import moe.plushie.armourers_workshop.core.skin.part.feet.RightFootPartType;
import moe.plushie.armourers_workshop.core.skin.part.head.HatPartType;
import moe.plushie.armourers_workshop.core.skin.part.head.HeadPartType;
import moe.plushie.armourers_workshop.core.skin.part.item.ItemPartType;
import moe.plushie.armourers_workshop.core.skin.part.item.OverrideItemPartType;
import moe.plushie.armourers_workshop.core.skin.part.item.ShieldPartType;
import moe.plushie.armourers_workshop.core.skin.part.legs.LeftLegPartType;
import moe.plushie.armourers_workshop.core.skin.part.legs.RightLegPartType;
import moe.plushie.armourers_workshop.core.skin.part.legs.SkirtPartType;
import moe.plushie.armourers_workshop.core.skin.part.other.PartitionPartType;
import moe.plushie.armourers_workshop.core.skin.part.other.UnknownPartType;
import moe.plushie.armourers_workshop.core.skin.part.wings.LeftWingPartType;
import moe.plushie.armourers_workshop.core.skin.part.wings.RightWingPartType;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.SkinResourceLocation;

public final class SkinPartTypes {
    private static final Map<String, ISkinPartType> ALL_PART_TYPES = new HashMap<String, ISkinPartType>();
    public static final ISkinPartType UNKNOWN = SkinPartTypes.register("unknown", new UnknownPartType());
    public static final ISkinPartType BIPPED_HAT = SkinPartTypes.register("hat.base", new HatPartType());
    public static final ISkinPartType BIPPED_HEAD = SkinPartTypes.register("head.base", new HeadPartType());
    public static final ISkinPartType BIPPED_CHEST = SkinPartTypes.register("chest.base", new ChestPartType());
    public static final ISkinPartType BIPPED_LEFT_ARM = SkinPartTypes.register("chest.leftArm", new LeftArmPartType());
    public static final ISkinPartType BIPPED_RIGHT_ARM = SkinPartTypes.register("chest.rightArm", new RightArmPartType());
    public static final ISkinPartType BIPPED_SKIRT = SkinPartTypes.register("legs.skirt", new SkirtPartType());
    public static final ISkinPartType BIPPED_LEFT_THIGH = SkinPartTypes.register("legs.leftLeg", new LeftLegPartType());
    public static final ISkinPartType BIPPED_RIGHT_THIGH = SkinPartTypes.register("legs.rightLeg", new RightLegPartType());
    public static final ISkinPartType BIPPED_LEFT_FOOT = SkinPartTypes.register("feet.leftFoot", new LeftFootPartType());
    public static final ISkinPartType BIPPED_RIGHT_FOOT = SkinPartTypes.register("feet.rightFoot", new RightFootPartType());
    public static final ISkinPartType BIPPED_LEFT_WING = SkinPartTypes.register("wings.leftWing", new LeftWingPartType());
    public static final ISkinPartType BIPPED_RIGHT_WING = SkinPartTypes.register("wings.rightWing", new RightWingPartType());
    public static final ISkinPartType BIPPED_LEFT_PHALANX = SkinPartTypes.register("wings.leftWing2", new PartitionPartType(BIPPED_LEFT_WING));
    public static final ISkinPartType BIPPED_RIGHT_PHALANX = SkinPartTypes.register("wings.rightWing2", new PartitionPartType(BIPPED_RIGHT_WING));
    public static final ISkinPartType BIPPED_TORSO = SkinPartTypes.register("chest.base2", new PartitionPartType(BIPPED_CHEST));
    public static final ISkinPartType BIPPED_LEFT_HAND = SkinPartTypes.register("chest.leftArm2", new PartitionPartType(BIPPED_LEFT_ARM));
    public static final ISkinPartType BIPPED_RIGHT_HAND = SkinPartTypes.register("chest.rightArm2", new PartitionPartType(BIPPED_RIGHT_ARM));
    public static final ISkinPartType BIPPED_LEFT_LEG = SkinPartTypes.register("legs.leftLeg2", new PartitionPartType(BIPPED_LEFT_THIGH));
    public static final ISkinPartType BIPPED_RIGHT_LEG = SkinPartTypes.register("legs.rightLeg2", new PartitionPartType(BIPPED_RIGHT_THIGH));
    public static final ISkinPartType ITEM_PICKAXE = SkinPartTypes.register("pickaxe.base", new ItemPartType());
    public static final ISkinPartType ITEM_AXE = SkinPartTypes.register("axe.base", new ItemPartType());
    public static final ISkinPartType ITEM_SHOVEL = SkinPartTypes.register("shovel.base", new ItemPartType());
    public static final ISkinPartType ITEM_HOE = SkinPartTypes.register("hoe.base", new ItemPartType());
    public static final ISkinPartType ITEM_BOW0 = SkinPartTypes.register("bow.frame0", new BowPartType(0));
    public static final ISkinPartType ITEM_BOW1 = SkinPartTypes.register("bow.frame1", new BowPartType(1));
    public static final ISkinPartType ITEM_BOW2 = SkinPartTypes.register("bow.frame2", new BowPartType(2));
    public static final ISkinPartType ITEM_BOW3 = SkinPartTypes.register("bow.frame3", new BowPartType(3));
    public static final ISkinPartType ITEM_ARROW = SkinPartTypes.register("bow.arrow", new ArrowPartType());
    public static final ISkinPartType ITEM_SWORD = SkinPartTypes.register("sword.base", new ItemPartType());
    public static final ISkinPartType ITEM_SHIELD = SkinPartTypes.register("shield.base", new ShieldPartType());
    public static final ISkinPartType ITEM_TRIDENT = SkinPartTypes.register("trident.base", new ItemPartType());
    public static final ISkinPartType ITEM_BOAT_BODY = SkinPartTypes.register("boat.base", new ItemPartType());
    public static final ISkinPartType ITEM_BOAT_LEFT_PADDLE = SkinPartTypes.register("boat.leftPaddle", new ItemPartType());
    public static final ISkinPartType ITEM_BOAT_RIGHT_PADDLE = SkinPartTypes.register("boat.rightPaddle", new ItemPartType());
    public static final ISkinPartType ITEM_FISHING_ROD = SkinPartTypes.register("fishing.rod", new ItemPartType());
    public static final ISkinPartType ITEM_FISHING_HOOK = SkinPartTypes.register("fishing.hook", new ItemPartType());
    public static final ISkinPartType ITEM_SHIELD1 = SkinPartTypes.register("shield.blocking", new OverrideItemPartType("blocking"));
    public static final ISkinPartType ITEM_TRIDENT1 = SkinPartTypes.register("trident.throwing", new OverrideItemPartType("throwing"));
    public static final ISkinPartType ITEM_FISHING_ROD1 = SkinPartTypes.register("fishing.rod1", new OverrideItemPartType("cast"));
    public static final ISkinPartType ITEM = SkinPartTypes.register("item.base", new ItemPartType());
    public static final ISkinPartType BLOCK = SkinPartTypes.register("block.base", new BlockPartType());
    public static final ISkinPartType BLOCK_MULTI = SkinPartTypes.register("block.multiblock", new MultiBlockPartType());
    public static final ISkinPartType ADVANCED = SkinPartTypes.register("part.advanced_part", new AdvancedPartType());
    public static final ISkinPartType ADVANCED_LOCATOR = SkinPartTypes.register("part.advanced_locator", new AdvancedPartType());
    public static final ISkinPartType HORSE_HEAD = SkinPartTypes.register("horse.head", new AdvancedPartType());
    public static final ISkinPartType HORSE_NECK = SkinPartTypes.register("horse.neck", new AdvancedPartType());
    public static final ISkinPartType HORSE_CHEST = SkinPartTypes.register("horse.chest", new AdvancedPartType());
    public static final ISkinPartType HORSE_LEFT_FRONT_THIGH = SkinPartTypes.register("horse.left_front_leg", new AdvancedPartType());
    public static final ISkinPartType HORSE_RIGHT_FRONT_THIGH = SkinPartTypes.register("horse.right_front_leg", new AdvancedPartType());
    public static final ISkinPartType HORSE_LEFT_HIND_THIGH = SkinPartTypes.register("horse.left_hind_leg", new AdvancedPartType());
    public static final ISkinPartType HORSE_RIGHT_HIND_THIGH = SkinPartTypes.register("horse.right_hind_leg", new AdvancedPartType());
    public static final ISkinPartType HORSE_LEFT_FRONT_LEG = SkinPartTypes.register("horse.left_front_leg2", new AdvancedPartType());
    public static final ISkinPartType HORSE_RIGHT_FRONT_LEG = SkinPartTypes.register("horse.right_front_leg2", new AdvancedPartType());
    public static final ISkinPartType HORSE_LEFT_HIND_LEG = SkinPartTypes.register("horse.left_hind_leg2", new AdvancedPartType());
    public static final ISkinPartType HORSE_RIGHT_HIND_LEG = SkinPartTypes.register("horse.right_hind_leg2", new AdvancedPartType());
    public static final ISkinPartType HORSE_TAIL = SkinPartTypes.register("horse.tail", new AdvancedPartType());

    public static ISkinPartType byName(String registryName) {
        if (registryName == null) {
            return UNKNOWN;
        }
        if (registryName.equals("armourers:skirt.base")) {
            return BIPPED_SKIRT;
        }
        if (registryName.equals("armourers:bow.base")) {
            return ITEM_BOW1;
        }
        if (registryName.equals("armourers:arrow.base")) {
            return ITEM_ARROW;
        }
        return ALL_PART_TYPES.getOrDefault(registryName, UNKNOWN);
    }

    public static Set<String> registeredNames() {
        return ALL_PART_TYPES.keySet();
    }

    public static Collection<ISkinPartType> registeredTypes() {
        return ALL_PART_TYPES.values();
    }

    private static ISkinPartType register(String name, SkinPartType partType) {
        partType.setRegistryName(new SkinResourceLocation("armourers", name));
        if (ALL_PART_TYPES.containsKey(partType.getRegistryName().toString())) {
            ModLog.warn("A mod tried to register a skin type with a registry name that is in use.", new Object[0]);
            return partType;
        }
        ALL_PART_TYPES.put(partType.getRegistryName().toString(), partType);
        ModLog.debug("Registering Skin Part '{}'", partType.getRegistryName());
        return partType;
    }
}

