/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.IntConsumer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlags;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;

public class ChunkNode {
    public ChunkNode next;
    public int index;

    public ChunkNode(int index) {
        this.index = index;
    }

    public static ChunkNode of(int index, ChunkVariable var, ChunkOutputStream stream) {
        if (var != null) {
            return new Variable(index, var, stream);
        }
        return new ChunkNode(index);
    }

    public void write(byte[] bytes, OutputStream stream) throws IOException {
        if (this.next != null && this.next.index != this.index) {
            stream.write(bytes, this.index, this.next.index - this.index);
        }
    }

    public int length() throws IOException {
        int length = 0;
        if (this.next != null) {
            length += this.next.index - this.index;
        }
        return length;
    }

    public boolean freeze() throws IOException {
        return true;
    }

    public boolean resolved() {
        return true;
    }

    private static boolean freezeRange(ChunkNode start, ChunkNode end) throws IOException {
        boolean flag = true;
        ChunkNode node = start;
        while (node != null && node != end) {
            if (!node.freeze()) {
                flag = false;
            }
            node = node.next;
        }
        return flag;
    }

    public static class Variable
    extends ChunkNode {
        private ChunkVariable var;
        private ChunkOutputStream stream;
        private int varStart;
        private int varEnd;
        private boolean resolved;

        public Variable(int index, ChunkVariable var, ChunkOutputStream stream) {
            super(index);
            this.var = var;
            this.stream = stream;
        }

        @Override
        public void write(byte[] bytes, OutputStream stream) throws IOException {
            if (this.var != null && this.varStart != this.varEnd) {
                stream.write(bytes, this.varStart, this.varEnd - this.varStart);
            }
            super.write(bytes, stream);
        }

        @Override
        public int length() throws IOException {
            int length = super.length();
            if (this.var != null) {
                length += this.varEnd - this.varStart;
            }
            return length;
        }

        @Override
        public boolean freeze() throws IOException {
            if (this.var != null) {
                if (this.var.freeze()) {
                    this.resolved = true;
                    this.updateIfNeeded();
                    return true;
                }
                return false;
            }
            return super.freeze();
        }

        @Override
        public boolean resolved() {
            if (this.var != null) {
                return this.resolved;
            }
            return super.resolved();
        }

        private void updateIfNeeded() throws IOException {
            if (this.stream != null && this.var != null) {
                this.varStart = this.stream.getBuffer().writerIndex();
                this.var.writeToStream(this.stream);
                this.varEnd = this.stream.getBuffer().writerIndex();
                this.stream = null;
            }
        }
    }

    public static class Compressed
    extends ChunkNode {
        private final ChunkFlags flags;
        private final ChunkNode start;
        private int length = 0;
        private ByteBuf buf;
        private ChunkOutputStream stream;

        public Compressed(int index, ChunkNode start, ChunkFlags flags, ChunkOutputStream stream) {
            super(index);
            this.start = start;
            this.flags = flags;
            this.stream = stream;
        }

        @Override
        public void write(byte[] bytes, OutputStream stream) throws IOException {
            stream.write(this.buf.array(), 0, this.length);
        }

        @Override
        public int length() throws IOException {
            return this.length;
        }

        @Override
        public boolean freeze() throws IOException {
            if (ChunkNode.freezeRange(this.start, (ChunkNode)this)) {
                this.updateIfNeeded();
                return true;
            }
            return false;
        }

        private void updateIfNeeded() throws IOException {
            if (this.start == null || this.stream == null) {
                return;
            }
            this.buf = Unpooled.buffer((int)1024);
            OutputStream outputStream = this.stream.getContext().createOutputStream(this.buf, this.flags);
            byte[] bytes = this.stream.getBuffer().array();
            ChunkNode node = this.start;
            while (node != null && node != this) {
                node.write(bytes, outputStream);
                ChunkNode next = node.next;
                node.next = null;
                node = next;
            }
            outputStream.flush();
            outputStream.close();
            this.stream = null;
            this.length = this.buf.writerIndex();
            this.start.next = this;
            this.index = this.start.index;
        }
    }

    public static class Sum
    extends ChunkNode {
        private final ChunkNode start;
        private IntConsumer callback;

        public Sum(int index, ChunkNode start, IntConsumer callback) {
            super(index);
            this.start = start;
            this.callback = callback;
        }

        @Override
        public boolean freeze() throws IOException {
            if (ChunkNode.freezeRange(this.start, (ChunkNode)this)) {
                this.updateIfNeeded();
                return true;
            }
            return false;
        }

        private void updateIfNeeded() throws IOException {
            if (this.callback != null) {
                this.callback.accept(this.getEstimatedLength());
                this.callback = null;
            }
        }

        private int getEstimatedLength() throws IOException {
            int length = 0;
            ChunkNode node = this.start;
            while (node != null) {
                length += node.length();
                if (node == this) break;
                node = node.next;
            }
            return length;
        }
    }
}

