/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer.bedrock;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.api.skin.ISkinArmorType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.cube.impl.SkinCubesV0;
import moe.plushie.armourers_workshop.core.skin.cube.impl.SkinCubesV2;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelBone;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelCube;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelTexture;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Size3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import moe.plushie.armourers_workshop.utils.texture.TextureBox;
import org.apache.commons.lang3.tuple.Pair;

public class BedrockModelExporter {
    protected Vector3f baseOrigin = Vector3f.ZERO;
    protected SkinSettings settings = new SkinSettings();
    protected SkinProperties properties = new SkinProperties();
    protected SkinItemTransforms itemTransforms = new SkinItemTransforms();
    protected Node rootNode = new Node("", null, null);
    protected HashMap<String, Node> namedNodes = new HashMap();
    protected ArrayList<Pair<String, Node>> allNodes = new ArrayList();
    protected Map<String, ISkinPartType> mapper = PARTS;
    protected boolean keepItemTransforms = false;
    private static final ImmutableMap<String, ISkinPartType> PARTS = new ImmutableMap.Builder().put((Object)"head_c", (Object)SkinPartTypes.BIPPED_HEAD).put((Object)"left_arm_c", (Object)SkinPartTypes.BIPPED_LEFT_ARM).put((Object)"right_arm_c", (Object)SkinPartTypes.BIPPED_RIGHT_ARM).put((Object)"body_c", (Object)SkinPartTypes.BIPPED_CHEST).put((Object)"left_leg_c", (Object)SkinPartTypes.BIPPED_LEFT_THIGH).put((Object)"right_leg_c", (Object)SkinPartTypes.BIPPED_RIGHT_THIGH).put((Object)"Body", (Object)SkinPartTypes.BIPPED_CHEST).put((Object)"LeftArm", (Object)SkinPartTypes.BIPPED_LEFT_ARM).put((Object)"RightArm", (Object)SkinPartTypes.BIPPED_RIGHT_ARM).put((Object)"LeftForeArm", (Object)SkinPartTypes.BIPPED_LEFT_HAND).put((Object)"RightForeArm", (Object)SkinPartTypes.BIPPED_RIGHT_HAND).put((Object)"LeftLeg", (Object)SkinPartTypes.BIPPED_LEFT_THIGH).put((Object)"RightLeg", (Object)SkinPartTypes.BIPPED_RIGHT_THIGH).put((Object)"LeftForeLeg", (Object)SkinPartTypes.BIPPED_LEFT_LEG).put((Object)"RightForeLeg", (Object)SkinPartTypes.BIPPED_RIGHT_LEG).put((Object)"LeftFoot", (Object)SkinPartTypes.BIPPED_LEFT_FOOT).put((Object)"RightFoot", (Object)SkinPartTypes.BIPPED_RIGHT_FOOT).put((Object)"Head", (Object)SkinPartTypes.BIPPED_HEAD).put((Object)"Chest", (Object)SkinPartTypes.BIPPED_CHEST).put((Object)"Arm_L", (Object)SkinPartTypes.BIPPED_LEFT_ARM).put((Object)"Arm_R", (Object)SkinPartTypes.BIPPED_RIGHT_ARM).put((Object)"Foot_L", (Object)SkinPartTypes.BIPPED_LEFT_FOOT).put((Object)"Foot_R", (Object)SkinPartTypes.BIPPED_RIGHT_FOOT).put((Object)"Thigh_L", (Object)SkinPartTypes.BIPPED_LEFT_THIGH).put((Object)"Thigh_R", (Object)SkinPartTypes.BIPPED_RIGHT_THIGH).put((Object)"Skirt", (Object)SkinPartTypes.BIPPED_SKIRT).put((Object)"Wing_L", (Object)SkinPartTypes.BIPPED_RIGHT_WING).put((Object)"Wing_R", (Object)SkinPartTypes.BIPPED_LEFT_WING).put((Object)"Phalanx_L", (Object)SkinPartTypes.BIPPED_RIGHT_PHALANX).put((Object)"Phalanx_R", (Object)SkinPartTypes.BIPPED_LEFT_PHALANX).put((Object)"Torso", (Object)SkinPartTypes.BIPPED_TORSO).put((Object)"Hand_L", (Object)SkinPartTypes.BIPPED_LEFT_HAND).put((Object)"Hand_R", (Object)SkinPartTypes.BIPPED_RIGHT_HAND).put((Object)"Leg_L", (Object)SkinPartTypes.BIPPED_LEFT_LEG).put((Object)"Leg_R", (Object)SkinPartTypes.BIPPED_RIGHT_LEG).build();
    private static final ImmutableMap<String, ISkinPartType> BOW_PARTS = new ImmutableMap.Builder().put((Object)"Arrow", (Object)SkinPartTypes.ITEM_ARROW).put((Object)"Frame0", (Object)SkinPartTypes.ITEM_BOW0).put((Object)"Frame1", (Object)SkinPartTypes.ITEM_BOW1).put((Object)"Frame2", (Object)SkinPartTypes.ITEM_BOW2).put((Object)"Frame3", (Object)SkinPartTypes.ITEM_BOW3).build();
    private static final ImmutableMap<String, ISkinPartType> FINISHING_PARTS = new ImmutableMap.Builder().put((Object)"Hook", (Object)SkinPartTypes.ITEM_FISHING_HOOK).put((Object)"Frame0", (Object)SkinPartTypes.ITEM_FISHING_ROD).put((Object)"Frame1", (Object)SkinPartTypes.ITEM_FISHING_ROD1).build();
    private static final ImmutableMap<ISkinPartType, IVector3i> PART_OFFSETS = new ImmutableMap.Builder().put((Object)SkinPartTypes.BIPPED_TORSO, (Object)new Vector3i(0, 6, 0)).put((Object)SkinPartTypes.BIPPED_LEFT_HAND, (Object)new Vector3i(0, 4, 0)).put((Object)SkinPartTypes.BIPPED_RIGHT_HAND, (Object)new Vector3i(0, 4, 0)).put((Object)SkinPartTypes.BIPPED_LEFT_LEG, (Object)new Vector3i(0, 6, 0)).put((Object)SkinPartTypes.BIPPED_RIGHT_LEG, (Object)new Vector3i(0, 6, 0)).build();

    public void add(BedrockModelBone bone, BedrockModelTexture texture) {
        Node node = new Node(bone.getName(), bone, texture);
        this.allNodes.add((Pair<String, Node>)Pair.of((Object)bone.getParent(), (Object)node));
        this.namedNodes.put(bone.getName(), node);
    }

    public void add(String name, ITransformf transform) {
        this.itemTransforms.put(name, transform);
    }

    public <T> void add(ISkinProperty<T> property, T value) {
        this.properties.put(property, value);
    }

    public void move(Vector3f offset) {
        this.baseOrigin = offset;
    }

    public Skin export(ISkinType skinType) {
        if (skinType == SkinTypes.ITEM_BOW) {
            this.mapper = BOW_PARTS;
        }
        if (skinType == SkinTypes.ITEM_FISHING) {
            this.mapper = FINISHING_PARTS;
        }
        this.allNodes.forEach((Consumer<Pair<String, Node>>)((Consumer<Pair>)it -> {
            String parentName = (String)it.getKey();
            if (parentName == null || parentName.isEmpty() || parentName.equalsIgnoreCase("none")) {
                this.rootNode.add((Node)it.getValue());
                return;
            }
            Node parent = this.namedNodes.get(parentName);
            if (parent == null) {
                parent = new Node(parentName, null, null);
                this.rootNode.add(parent);
                this.namedNodes.put(parentName, parent);
            }
            parent.add((Node)it.getValue());
        }));
        ArrayList<SkinPart> rootParts = new ArrayList<SkinPart>();
        for (Node child : this.rootNode.children) {
            this.exportSkinPart(child, null, rootParts);
        }
        Skin.Builder builder = this.createSkin(skinType);
        if (skinType == SkinTypes.ADVANCED || skinType == SkinTypes.OUTFIT || skinType == SkinTypes.ITEM_BOW || skinType instanceof ISkinArmorType) {
            builder.parts(rootParts);
        } else if (skinType.getParts().size() == 1) {
            SkinPart.Builder builder1 = new SkinPart.Builder(skinType.getParts().get(0));
            builder1.cubes(new SkinCubesV0(0));
            SkinPart rootPart = builder1.build();
            rootParts.forEach(rootPart::addPart);
            builder.parts(Collections.singleton(rootPart));
        } else {
            builder.parts(rootParts);
        }
        builder.settings(this.settings);
        builder.properties(this.properties);
        if (this.isKeepItemTransforms()) {
            this.settings.setItemTransforms(this.itemTransforms);
        }
        builder.version(20);
        return builder.build();
    }

    protected Skin.Builder createSkin(ISkinType skinType) {
        return new Skin.Builder(skinType);
    }

    protected void exportSkinPart(Node node, SkinPart parentPart, Collection<SkinPart> rootParts) {
        IVector3i iv = Vector3i.ZERO;
        IVector3i of = Vector3i.ZERO;
        ISkinPartType partType = this.mapper.getOrDefault(node.name, SkinPartTypes.ADVANCED);
        if (partType != null && partType != SkinPartTypes.ADVANCED) {
            parentPart = null;
            iv = partType.getRenderOffset();
            of = (IVector3i)PART_OFFSETS.getOrDefault((Object)partType, (Object)of);
        }
        SkinPart part = this.exportSkinPart(node, partType, iv, of);
        if (parentPart != null) {
            parentPart.addPart(part);
        } else {
            rootParts.add(part);
        }
        for (Node child : node.children) {
            this.exportSkinPart(child, part, rootParts);
        }
    }

    protected SkinPart exportSkinPart(Node node, ISkinPartType partType, IVector3i iv, IVector3i of) {
        BedrockModelBone bone = node.bone;
        Vector3f pivot = Vector3f.ZERO;
        Vector3f translate = Vector3f.ZERO;
        Vector3f rotation = Vector3f.ZERO;
        if (bone != null) {
            pivot = this.convertToLocal(bone.getPivot());
            rotation = bone.getRotation();
        }
        float tx = of.getX() + iv.getX();
        float ty = of.getY() + iv.getY();
        float tz = of.getZ() + iv.getZ();
        translate = new Vector3f(-tx, -ty, -tz);
        SkinCubesV2 cubes = new SkinCubesV2();
        SkinPart.Builder builder = new SkinPart.Builder(partType);
        builder.cubes(cubes);
        builder.transform(SkinTransform.create(Vector3f.ZERO, rotation, Vector3f.ONE, pivot, translate));
        if (bone != null) {
            builder.name(bone.getName());
            for (BedrockModelCube cube : bone.getCubes()) {
                SkinCubesV2.Box entry = this.exportSkinCube(cube, node.texture);
                cubes.addBox(entry);
            }
        }
        return builder.build();
    }

    protected SkinCubesV2.Box exportSkinCube(BedrockModelCube cube, BedrockModelTexture texture) {
        Vector3f pivot = this.convertToLocal(cube.getPivot());
        Vector3f translate = Vector3f.ZERO;
        Vector3f rotation = cube.getRotation();
        Vector3f origin = this.convertToLocal(cube.getOrigin());
        Size3f size = cube.getSize();
        float x = origin.getX();
        float y = origin.getY();
        float z = origin.getZ();
        float w = size.getWidth();
        float h = size.getHeight();
        float d = size.getDepth();
        float delta = cube.getInflate();
        TextureBox skyBox = texture.read(cube);
        if (delta != 0.0f) {
            skyBox = skyBox.separated();
        }
        Rectangle3f rect = new Rectangle3f(x, y, z, w, h, d).inflate(delta);
        SkinTransform transform = SkinTransform.create(Vector3f.ZERO, rotation, Vector3f.ONE, pivot, translate);
        return new SkinCubesV2.Box(rect, transform, skyBox);
    }

    protected Vector3f convertToLocal(Vector3f pos) {
        if (!this.baseOrigin.equals(Vector3f.ZERO)) {
            return pos.subtracting(this.baseOrigin);
        }
        return pos;
    }

    public boolean isKeepItemTransforms() {
        return this.keepItemTransforms;
    }

    public void setKeepItemTransforms(boolean keepItemTransforms) {
        this.keepItemTransforms = keepItemTransforms;
    }

    public static class Node {
        public final String name;
        public final BedrockModelBone bone;
        public final BedrockModelTexture texture;
        public final ArrayList<Node> children = new ArrayList();

        public Node(String name, BedrockModelBone bone, BedrockModelTexture texture) {
            this.bone = bone;
            this.name = name;
            this.texture = texture;
        }

        public void add(Node node) {
            this.children.add(node);
        }
    }
}

