/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer.blockbench;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.transformer.SkinPack;
import moe.plushie.armourers_workshop.core.skin.transformer.SkinPackModelReader;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModel;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelBone;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelCube;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelGeometry;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelTexture;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelUV;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockTransform;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchElement;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchModelTexture;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchModelUV;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchOutliner;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchPack;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle2f;
import moe.plushie.armourers_workshop.utils.math.Size3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.util.Direction;
import org.jetbrains.annotations.Nullable;

public class BlockBenchModelReader
implements SkinPackModelReader {
    private final BlockBenchPack pack;
    private final BlockBenchModelTexture texture;
    private final Vector3f baseOrigin;
    private final HashSet<Integer> usedTextureIds = new HashSet();

    public BlockBenchModelReader(String name, BlockBenchPack pack) {
        this.pack = pack;
        this.texture = new BlockBenchModelTexture(pack.getResolution(), pack.getTextures());
        this.baseOrigin = this.convertToLocal(pack.getOrigin());
    }

    @Override
    public BedrockModel readModel() throws IOException {
        BedrockModelGeometry.Builder builder = new BedrockModelGeometry.Builder();
        builder.identifier("geometry.steve");
        builder.textureWidth(this.pack.getResolution().getWidth());
        builder.textureHeight(this.pack.getResolution().getHeight());
        builder.visibleWidth(this.pack.getVisibleBox().getWidth());
        builder.visibleHeight(this.pack.getVisibleBox().getHeight());
        builder.visibleOffset(new Vector3f(0.0f, this.pack.getVisibleBox().getDepth(), 0.0f));
        builder.addBones(this.convertToBone(this.pack.getRootOutliner(), null));
        BedrockModel.Builder rootBuilder = new BedrockModel.Builder();
        rootBuilder.formatVersion("1.12.0");
        rootBuilder.addGeometry(builder.build());
        return rootBuilder.build();
    }

    @Override
    public BedrockModelTexture readTexture(BedrockModelGeometry geometry) throws IOException {
        this.texture.load(this.usedTextureIds);
        return this.texture;
    }

    @Override
    public Map<String, BedrockTransform> getTransforms() {
        if (this.pack.getTransforms() == null) {
            return null;
        }
        HashMap<String, BedrockTransform> results = new HashMap<String, BedrockTransform>();
        this.pack.getTransforms().forEach((name, transform) -> {
            BedrockTransform.Builder builder = new BedrockTransform.Builder();
            builder.translation(this.convertToLocal(transform.getTranslation()));
            builder.rotation(this.convertToLocal(transform.getRotation()));
            builder.scale(transform.getScale());
            results.put((String)name, builder.build());
        });
        return results;
    }

    @Override
    public SkinPack getPack() {
        return this.pack;
    }

    private ArrayList<BedrockModelBone> convertToBone(BlockBenchOutliner outliner, @Nullable BlockBenchOutliner parentOutliner) {
        ArrayList<BedrockModelBone> bones = new ArrayList<BedrockModelBone>();
        if (!outliner.allowExport()) {
            return bones;
        }
        BedrockModelBone.Builder builder = new BedrockModelBone.Builder();
        builder.name(outliner.getName());
        if (parentOutliner != null) {
            builder.parent(parentOutliner.getName());
        }
        if (!outliner.getOrigin().equals(Vector3f.ZERO)) {
            builder.pivot(this.convertToLocal(outliner.getOrigin()).subtracting(this.baseOrigin));
        }
        if (!outliner.getRotation().equals(Vector3f.ZERO)) {
            builder.rotation(this.convertToLocal(outliner.getRotation()));
        }
        builder.mirror(false);
        for (Object child : outliner.getChildren()) {
            BlockBenchElement element;
            BlockBenchOutliner childOutliner = ObjectUtils.safeCast(child, BlockBenchOutliner.class);
            if (childOutliner != null) {
                bones.addAll(this.convertToBone(childOutliner, outliner));
                continue;
            }
            String ref = ObjectUtils.safeCast(child, String.class);
            if (ref == null || (element = ObjectUtils.safeCast(this.pack.getObject(ref), BlockBenchElement.class)) == null || !element.allowExport() || !element.getType().equals("cube")) continue;
            builder.addCube(this.convertToCube(element));
        }
        bones.add(0, builder.build());
        return bones;
    }

    private BedrockModelCube convertToCube(BlockBenchElement element) {
        BedrockModelCube.Builder builder = new BedrockModelCube.Builder();
        builder.origin(this.convertToCubeOrigin(element).subtracting(this.baseOrigin));
        builder.size(this.convertToCubeSize(element));
        builder.inflate(element.getInflate());
        if (!element.getRotation().equals(Vector3f.ZERO)) {
            builder.pivot(this.convertToLocal(element.getOrigin()).subtracting(this.baseOrigin));
            builder.rotation(this.convertToLocal(element.getRotation()));
        }
        builder.uv(this.convertToCubeUV(element));
        return builder.build();
    }

    private Vector3f convertToCubeOrigin(BlockBenchElement element) {
        Vector3f from = element.getFrom();
        Vector3f to = element.getTo();
        return new Vector3f(-to.getX(), -to.getY(), from.getZ());
    }

    private Size3f convertToCubeSize(BlockBenchElement element) {
        Vector3f from = element.getFrom();
        Vector3f to = element.getTo();
        return new Size3f(to.getX() - from.getX(), to.getY() - from.getY(), to.getZ() - from.getZ());
    }

    private BedrockModelUV convertToCubeUV(BlockBenchElement element) {
        if (element.isBoxUV()) {
            BlockBenchModelUV uv = new BlockBenchModelUV(element.getUVOffset());
            element.getFaces().forEach((dir, face) -> {
                uv.setDefaultTextureId(face.getTextureId());
                uv.setRotation((Direction)dir, face.getRotation());
                this.usedTextureIds.add(face.getTextureId());
            });
            return uv;
        }
        BlockBenchModelUV uv = new BlockBenchModelUV(null);
        uv.setDefaultTextureId(-1);
        element.getFaces().forEach((dir, face) -> {
            if (face.getTextureId() < 0) {
                return;
            }
            Rectangle2f rect = face.getRect();
            if (dir == Direction.UP || dir == Direction.DOWN) {
                Rectangle2f fixedRect = rect.copy();
                fixedRect.setX(rect.getMaxX());
                fixedRect.setY(rect.getMaxY());
                fixedRect.setWidth(-rect.getWidth());
                fixedRect.setHeight(-rect.getHeight());
                rect = fixedRect;
            }
            uv.put((Direction)dir, rect);
            uv.setRotation((Direction)dir, face.getRotation());
            uv.setTextureId((Direction)dir, face.getTextureId());
            this.usedTextureIds.add(face.getTextureId());
        });
        return uv;
    }

    private Vector3f convertToLocal(Vector3f pos) {
        if (!pos.equals(Vector3f.ZERO)) {
            return pos.scaling(-1.0f, -1.0f, 1.0f);
        }
        return pos;
    }
}

