/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.skin.ISkinToolType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedFirstPersonArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemModel;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.utils.EmbeddedSkinStack;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
public class ClientWardrobeHandler {
    private static Runnable INVENTORY_RENDER_POST_EVENT = null;
    public static ItemStack RENDERING_GUI_ITEM = null;
    public static final float SCALE = 0.0625f;

    public static void init() {
    }

    public static void startRenderGuiItem(ItemStack itemStack) {
        RENDERING_GUI_ITEM = itemStack;
    }

    public static void endRenderGuiItem(ItemStack itemStack) {
        RENDERING_GUI_ITEM = null;
    }

    public static void onRenderTrident(TridentEntity entity, float partialTicks, int packedLight, MatrixStack poseStack, IRenderTypeBuffer buffers, CallbackInfo callback) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        poseStack.func_227860_a_();
        float xRot = PropertyProvider.getXRot((Entity)entity);
        float yRot = PropertyProvider.getYRot((Entity)entity);
        float xRotO = entity.field_70127_C;
        float yRotO = entity.field_70126_B;
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(MathUtils.lerp(partialTicks, yRotO, yRot) - 90.0f));
        ABI.mulPose(poseStack, Vector3f.ZP.rotationDegrees(MathUtils.lerp(partialTicks, xRotO, xRot) + 90.0f));
        ABI.mulPose(poseStack, Vector3f.ZP.rotationDegrees(180.0f));
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(-90.0f));
        poseStack.func_227862_a_(-0.0625f, -0.0625f, 0.0625f);
        poseStack.func_227861_a_(0.0, 11.0, 0.0);
        BakedArmature armature = BakedArmature.defaultBy(Armatures.ANY);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, TickUtils.ticks(), poseStack, buffers);
        int count = ClientWardrobeHandler.render((Entity)entity, armature, context, renderData::getItemSkins);
        if (count != 0 && !ModDebugger.itemOverride) {
            callback.cancel();
        }
        context.release();
        poseStack.func_227865_b_();
    }

    public static void onRenderArrow(AbstractArrowEntity entity, float partialTicks, int packedLight, MatrixStack poseStack, IRenderTypeBuffer buffers, CallbackInfo callback) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        SkinRenderData.Entry entry = ClientWardrobeHandler.getEntry(renderData.getItemSkins(), part -> part.getType() == SkinPartTypes.ITEM_ARROW);
        if (entry == null) {
            return;
        }
        poseStack.func_227860_a_();
        float xRot = PropertyProvider.getXRot((Entity)entity);
        float yRot = PropertyProvider.getYRot((Entity)entity);
        float xRotO = entity.field_70127_C;
        float yRotO = entity.field_70126_B;
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(MathUtils.lerp(partialTicks, yRotO, yRot) - 90.0f));
        ABI.mulPose(poseStack, Vector3f.ZP.rotationDegrees(MathUtils.lerp(partialTicks, xRotO, xRot)));
        float f9 = (float)entity.field_70249_b - partialTicks;
        if (f9 > 0.0f) {
            float f10 = -MathUtils.sin(f9 * 3.0f) * f9;
            ABI.mulPose(poseStack, Vector3f.ZP.rotationDegrees(f10));
        }
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(-90.0f));
        poseStack.func_227862_a_(-0.0625f, -0.0625f, 0.0625f);
        poseStack.func_227861_a_(0.0, 0.0, -1.0);
        BakedArmature armature = BakedArmature.defaultBy(Armatures.ANY);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, TickUtils.ticks(), poseStack, buffers);
        int count = ClientWardrobeHandler.render((Entity)entity, armature, context, () -> Collections.singletonList(entry));
        if (count != 0 && !ModDebugger.itemOverride) {
            callback.cancel();
        }
        context.release();
        poseStack.func_227865_b_();
    }

    public static void onRenderFishingHook(FishingBobberEntity entity, float partialTicks, int packedLight, MatrixStack poseStack, IRenderTypeBuffer buffers, CallbackInfo callback) {
        SkinRenderData.Entry entry;
        PlayerEntity player = entity.func_234606_i_();
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (player == null || renderData == null) {
            return;
        }
        ItemStack itemStack = player.func_184614_ca();
        if (!extensions.net.minecraft.world.item.ItemStack.ABI.is(itemStack, Items.field_151112_aM)) {
            itemStack = player.func_184592_cb();
        }
        if ((entry = ClientWardrobeHandler.createEntry(itemStack, part -> part.getType() == SkinPartTypes.ITEM_FISHING_HOOK)) == null) {
            return;
        }
        poseStack.func_227860_a_();
        Vector3f rotation = extensions.net.minecraft.client.Minecraft.ABI.getCameraOrientation(Minecraft.func_71410_x()).toYXZ();
        ABI.mulPose(poseStack, OpenQuaternionf.fromYXZ(rotation.getY(), 0.0f, 0.0f));
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(180.0f));
        poseStack.func_227862_a_(-0.0625f, -0.0625f, 0.0625f);
        poseStack.func_227861_a_(-0.5, -3.0, 0.0);
        BakedArmature armature = BakedArmature.defaultBy(Armatures.ANY);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, TickUtils.ticks(), poseStack, buffers);
        int count = ClientWardrobeHandler.render((Entity)entity, armature, context, () -> Collections.singletonList(entry));
        if (count != 0 && !ModDebugger.fishingHook) {
            callback.cancel();
        }
        context.release();
        poseStack.func_227865_b_();
    }

    public static void onRenderBoat(BoatEntity entity, Model model, float partialTicks, int packedLight, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        poseStack.func_227860_a_();
        poseStack.func_227862_a_(-0.0625f, -0.0625f, 0.0625f);
        BakedArmature armature = BakedArmature.defaultBy(Armatures.BOAT);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, TickUtils.ticks(), AbstractItemTransformType.NONE, poseStack, buffers);
        ClientWardrobeHandler.render((Entity)entity, armature, context, renderData::getArmorSkins);
        context.release();
        poseStack.func_227865_b_();
    }

    public static void onRenderSpecificHand(LivingEntity entity, float partialTicks, int packedLight, AbstractItemTransformType transformType, MatrixStack poseStack, IRenderTypeBuffer buffers, Runnable cancelHandler) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        poseStack.func_227860_a_();
        poseStack.func_227862_a_(-0.0625f, -0.0625f, 0.0625f);
        BakedFirstPersonArmature armature = BakedFirstPersonArmature.defaultBy(transformType);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, TickUtils.ticks(), transformType, poseStack, buffers);
        int count = ClientWardrobeHandler.render((Entity)entity, armature, context, renderData::getArmorSkins);
        if (count != 0 && !ModDebugger.handOverride) {
            cancelHandler.run();
        }
        context.release();
        poseStack.func_227865_b_();
    }

    public static void onRenderLivingEntityPre(LivingEntity entity, float partialTicks, int packedLight, MatrixStack poseStack, IRenderTypeBuffer buffers, LivingRenderer<?, ?> entityRenderer) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData != null) {
            SkinRendererManager.getInstance().willRender((Entity)entity, (Model)entityRenderer.func_217764_d(), (EntityRenderer<?>)entityRenderer, renderData, () -> SkinRenderContext.alloc(renderData, packedLight, partialTicks, poseStack, buffers));
        }
    }

    public static void onRenderLivingEntity(LivingEntity entity, float partialTicks, int packedLight, MatrixStack poseStack, IRenderTypeBuffer buffers, LivingRenderer<?, ?> entityRenderer) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData != null) {
            SkinRendererManager.getInstance().willRenderModel((Entity)entity, (Model)entityRenderer.func_217764_d(), (EntityRenderer<?>)entityRenderer, renderData, () -> SkinRenderContext.alloc(renderData, packedLight, partialTicks, poseStack, buffers));
        }
    }

    public static void onRenderLivingEntityPost(LivingEntity entity, float partialTicks, int packedLight, MatrixStack poseStack, IRenderTypeBuffer buffers, LivingRenderer<?, ?> entityRenderer) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData != null) {
            SkinRendererManager.getInstance().didRender((Entity)entity, (Model)entityRenderer.func_217764_d(), (EntityRenderer<?>)entityRenderer, renderData, () -> SkinRenderContext.alloc(renderData, packedLight, partialTicks, poseStack, buffers));
        }
    }

    @Nullable
    public static EmbeddedSkinStack getEmbeddedSkinStack(@Nullable LivingEntity entity, @Nullable World level, ItemStack itemStack, AbstractItemTransformType transformType) {
        Iterator<SkinRenderData.Entry> iterator;
        SkinRenderData renderData;
        if (RENDERING_GUI_ITEM != itemStack && (renderData = SkinRenderData.of((Entity)entity)) != null && (iterator = renderData.getItemSkins(itemStack, entity instanceof MannequinEntity).iterator()).hasNext()) {
            SkinRenderData.Entry entry = iterator.next();
            return new EmbeddedSkinStack(0, entry);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return null;
        }
        if (extensions.net.minecraft.world.item.ItemStack.ABI.is(itemStack, (Item)ModItems.SKIN.get())) {
            return new EmbeddedSkinStack(2, descriptor, itemStack);
        }
        if (descriptor.getOptions().getEmbeddedItemRenderer() != 0) {
            if (descriptor.getOptions().getEmbeddedItemRenderer() == 2) {
                return new EmbeddedSkinStack(1, descriptor, itemStack);
            }
            return null;
        }
        if (ModConfig.enableEmbeddedSkinRenderer() || descriptor.getType() == SkinTypes.ITEM) {
            return new EmbeddedSkinStack(1, descriptor, itemStack);
        }
        return null;
    }

    public static void renderEmbeddedSkin(@Nullable LivingEntity entity, @Nullable World level, ItemStack itemStack, EmbeddedSkinStack embeddedStack, AbstractItemTransformType transformType, boolean leftHandHackery, MatrixStack poseStack, IRenderTypeBuffer buffers, IBakedModel bakedModel, int packedLight, int overlay, CallbackInfo callback) {
        int counter = 0;
        switch (transformType) {
            case GUI: 
            case GROUND: 
            case FIXED: {
                counter = ClientWardrobeHandler._renderEmbeddedSkinInBox(embeddedStack, transformType, leftHandHackery, poseStack, buffers, packedLight, overlay);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                if (embeddedStack.getEntry() == null) {
                    if (ClientWardrobeHandler.shouldRenderInBox(embeddedStack)) {
                        counter = ClientWardrobeHandler._renderEmbeddedSkinInBox(embeddedStack, transformType, leftHandHackery, poseStack, buffers, packedLight, overlay);
                        break;
                    }
                    counter = ClientWardrobeHandler._renderEmbeddedSkin(embeddedStack, transformType, leftHandHackery, poseStack, buffers, packedLight, overlay);
                    break;
                }
                SkinRenderData renderData = SkinRenderData.of((Entity)entity);
                if (renderData == null) break;
                poseStack.func_227860_a_();
                poseStack.func_227862_a_(-0.0625f, -0.0625f, 0.0625f);
                BakedArmature armature = BakedArmature.defaultBy(Armatures.ANY);
                SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, TickUtils.ticks(), transformType, poseStack, buffers);
                context.setReferenced(SkinItemSource.create(800.0f, itemStack, transformType));
                counter = ClientWardrobeHandler.render((Entity)entity, armature, context, () -> Collections.singleton(embeddedStack.getEntry()));
                context.release();
                poseStack.func_227865_b_();
                break;
            }
        }
        if (counter != 0 && !ModDebugger.itemOverride) {
            callback.cancel();
        }
    }

    private static int _renderEmbeddedSkinInBox(EmbeddedSkinStack embeddedStack, AbstractItemTransformType transformType, boolean leftHandHackery, MatrixStack poseStack, IRenderTypeBuffer buffers, int packedLight, int overlay) {
        int count = 0;
        SkinDescriptor descriptor = embeddedStack.getDescriptor();
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.INVENTORY);
        if (bakedSkin == null) {
            return count;
        }
        Vector3f rotation = Vector3f.ZERO;
        Vector3f scale = Vector3f.ONE;
        poseStack.func_227860_a_();
        if (bakedSkin.getItemModel() == null) {
            BakedItemModel itemModel = BakedItemModel.DEFAULT;
            ItemTransformVec3f transform = extensions.net.minecraft.client.resources.model.BakedModel.ABI.getTransform((IBakedModel)itemModel, transformType);
            extensions.net.minecraft.client.resources.model.BakedModel.ABI.applyTransform((IBakedModel)itemModel, poseStack, leftHandHackery, transformType);
            rotation = new Vector3f(-transform.field_178364_b.func_195899_a(), -transform.field_178364_b.func_195900_b(), transform.field_178364_b.func_195902_c());
            scale = new Vector3f(transform.field_178363_d.func_195899_a(), transform.field_178363_d.func_195900_b(), transform.field_178363_d.func_195902_c());
        }
        SkinItemSource itemSource = SkinItemSource.create(descriptor.sharedItemStack());
        itemSource.setScale(scale);
        itemSource.setRotation(rotation);
        itemSource.setTransformType(transformType);
        ColorScheme scheme = descriptor.getColorScheme();
        count = ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, scale, 0.0f, packedLight, itemSource, poseStack, buffers);
        poseStack.func_227865_b_();
        return count;
    }

    private static int _renderEmbeddedSkin(EmbeddedSkinStack embeddedStack, AbstractItemTransformType transformType, boolean leftHandHackery, MatrixStack poseStack, IRenderTypeBuffer buffers, int packedLight, int overlay) {
        int count = 0;
        SkinDescriptor descriptor = embeddedStack.getDescriptor();
        SkinRenderTesselator context = SkinRenderTesselator.create(descriptor, Tickets.INVENTORY);
        if (context == null) {
            return count;
        }
        poseStack.func_227860_a_();
        poseStack.func_227862_a_(-16.0f, -16.0f, 16.0f);
        context.setRenderData(SkinRenderData.of((Entity)context.getMannequin()));
        context.setLightmap(packedLight);
        context.setPartialTicks(0.0f);
        context.setReferenced(SkinItemSource.create(800.0f, embeddedStack.getItemStack(), transformType));
        context.setColorScheme(descriptor.getColorScheme());
        count = context.draw(poseStack, buffers);
        poseStack.func_227865_b_();
        return count;
    }

    public static void onRenderEntityInInventoryPre(LivingEntity entity, int x, int y, int scale, float mouseX, float mouseY) {
        int top;
        int left;
        int height;
        int width;
        if (!ModConfig.Client.enableEntityInInventoryClip) {
            return;
        }
        switch (scale) {
            case 20: {
                width = 32;
                height = 43;
                left = x - width / 2 + 1;
                top = y - height + 4;
                break;
            }
            case 30: {
                width = 49;
                height = 70;
                left = x - width / 2 - 1;
                top = y - height + 3;
                break;
            }
            default: {
                return;
            }
        }
        RenderSystem.addClipRect(left, top, width, height);
        INVENTORY_RENDER_POST_EVENT = RenderSystem::removeClipRect;
    }

    public static void onRenderEntityInInventoryPost(LivingEntity entity) {
        if (INVENTORY_RENDER_POST_EVENT != null) {
            INVENTORY_RENDER_POST_EVENT.run();
            INVENTORY_RENDER_POST_EVENT = null;
        }
    }

    private static int render(Entity entity, BakedArmature bakedArmature, SkinRenderContext context, Supplier<Iterable<SkinRenderData.Entry>> provider) {
        int r = 0;
        for (SkinRenderData.Entry entry : provider.get()) {
            SkinItemSource itemSource = context.getReferenced();
            ItemStack itemStack = itemSource.getItem();
            if (itemStack.func_190926_b()) {
                itemStack = entry.getItemStack();
            }
            if (itemSource == SkinItemSource.EMPTY) {
                itemSource = SkinItemSource.create(itemStack);
            }
            itemSource.setItem(itemStack);
            itemSource.setRenderPriority(entry.getRenderPriority());
            context.setReferenced(itemSource);
            BakedSkin bakedSkin = entry.getBakedSkin();
            bakedSkin.setupAnim(entity, context.getPartialTicks(), itemSource);
            r += SkinRenderer.render(entity, bakedArmature, bakedSkin, entry.getBakedScheme(), context);
        }
        return r;
    }

    private static boolean shouldRenderInBox(EmbeddedSkinStack embeddedStack) {
        if (embeddedStack.getMode() == 2) {
            return true;
        }
        ISkinType skinType = embeddedStack.getDescriptor().getType();
        if (skinType instanceof ISkinToolType) {
            return false;
        }
        return skinType != SkinTypes.ITEM;
    }

    private static SkinRenderData.Entry createEntry(ItemStack itemStack, Predicate<BakedSkinPart> predicate) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.RENDERER);
        if (bakedSkin == null) {
            return null;
        }
        for (BakedSkinPart part : bakedSkin.getParts()) {
            if (!predicate.test(part)) continue;
            return new SkinRenderData.Entry(itemStack, descriptor, bakedSkin, ColorScheme.EMPTY, 0.0f, true);
        }
        return null;
    }

    private static SkinRenderData.Entry getEntry(Iterable<SkinRenderData.Entry> entries, Predicate<BakedSkinPart> predicate) {
        for (SkinRenderData.Entry entry1 : entries) {
            for (BakedSkinPart part : entry1.getBakedSkin().getParts()) {
                if (!predicate.test(part)) continue;
                return entry1;
            }
        }
        return null;
    }
}

