/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.function;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.ILootConditionalFunction;
import moe.plushie.armourers_workshop.api.common.IResultHandler;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import org.jetbrains.annotations.Nullable;

public class SkinRandomlyFunction
implements ILootConditionalFunction {
    public final List<SkinSource> sources;

    SkinRandomlyFunction(Collection<SkinSource> sources) {
        this.sources = ImmutableList.copyOf(sources);
    }

    @Override
    public ItemStack apply(ItemStack itemStack, LootContext lootContext) {
        SkinDescriptor descriptor = SkinDescriptor.EMPTY;
        ArrayList<SkinSource> pending = new ArrayList<SkinSource>(this.sources);
        while (descriptor.isEmpty() && !pending.isEmpty()) {
            int index = lootContext.func_216032_b().nextInt(pending.size());
            descriptor = pending.remove(index).apply(lootContext);
        }
        if (descriptor.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        SkinDescriptor.setDescriptor(itemStack, descriptor);
        return itemStack;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return new HashSet(ObjectUtils.compactMap(this.sources, SkinSource::getParam));
    }

    public static class SkinSource
    implements IResultHandler<SkinDescriptor> {
        private SkinDescriptor provider;
        private Function<LootContext, SkinDescriptor> searcher;
        private LootParameter<?> param;

        public SkinSource(IDataPackObject object) {
            switch (object.type()) {
                case STRING: {
                    String identifier = object.stringValue();
                    if (identifier.isEmpty()) break;
                    SkinLoader.getInstance().submit(() -> SkinLoader.getInstance().loadSkinFromDB(identifier, ColorScheme.EMPTY, this));
                    break;
                }
                case DICTIONARY: {
                    int slot = object.get("slot").intValue();
                    SkinSlotType slotType = SkinSlotType.byName(object.get("type").stringValue());
                    this.searcher = context -> this.search((LootContext)context, slotType, slot);
                    this.param = LootParameters.field_216281_a;
                    break;
                }
            }
        }

        public SkinDescriptor apply(LootContext lootContext) {
            if (this.provider != null) {
                return this.provider;
            }
            if (this.searcher != null) {
                return this.searcher.apply(lootContext);
            }
            return SkinDescriptor.EMPTY;
        }

        @Override
        public void apply(SkinDescriptor value, Exception exception) {
            this.provider = value;
        }

        public SkinDescriptor search(LootContext lootContext, @Nullable SkinSlotType slotType, int index) {
            Object value = lootContext.func_216031_c(this.param);
            SkinWardrobe wardrobe = SkinWardrobe.of(ObjectUtils.safeCast(value, Entity.class));
            if (wardrobe == null) {
                return SkinDescriptor.EMPTY;
            }
            SkinDescriptor descriptor = SkinDescriptor.EMPTY;
            ArrayList<ItemStack> pending = this.collect(wardrobe, slotType, index);
            while (descriptor.isEmpty() && !pending.isEmpty()) {
                index = lootContext.func_216032_b().nextInt(pending.size());
                descriptor = SkinDescriptor.of(pending.remove(index));
            }
            return descriptor;
        }

        public ArrayList<ItemStack> collect(SkinWardrobe wardrobe, @Nullable SkinSlotType slotType, int index) {
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            if (slotType == null) {
                for (SkinSlotType slotType1 : SkinSlotType.values()) {
                    if (slotType1.getSkinType() == null) continue;
                    results.addAll(this.collect(wardrobe, slotType1, index));
                }
                return results;
            }
            if (index != 0) {
                results.add(wardrobe.getItem(slotType, index));
                return results;
            }
            int count = wardrobe.getUnlockedSize(slotType);
            for (int i = 0; i < count; ++i) {
                results.add(wardrobe.getItem(slotType, i));
            }
            return results;
        }

        public LootParameter<?> getParam() {
            return this.param;
        }
    }

    public static class Serializer
    implements ILootConditionalFunction.Serializer<SkinRandomlyFunction> {
        @Override
        public void serialize(IDataPackObject object, SkinRandomlyFunction function) {
            if (function.sources.isEmpty()) {
                return;
            }
        }

        @Override
        public SkinRandomlyFunction deserialize(IDataPackObject object) {
            ArrayList<SkinSource> list = new ArrayList<SkinSource>();
            object.get("skins").allValues().forEach(it -> list.add(new SkinSource((IDataPackObject)it)));
            return new SkinRandomlyFunction(list);
        }
    }
}

