/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGRect;
import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import extensions.net.minecraft.world.item.ItemStack.ABI;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.ISkinEquipmentType;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinOptions;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModKeyBindings;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.RegistryManager;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.Strings;

@OnlyIn(value=Dist.CLIENT)
public class ItemTooltipManager {
    public static ArrayList<ITextComponent> createSkinInfo(BakedSkin bakedSkin) {
        Skin skin = bakedSkin.getSkin();
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (Strings.isNotBlank((String)skin.getCustomName().trim())) {
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinName", skin.getCustomName().trim()));
        }
        if (Strings.isNotBlank((String)skin.getAuthorName())) {
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinAuthor", skin.getAuthorName().trim()));
        }
        tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinType", TranslateUtils.Name.of(skin.getType())));
        return tooltip;
    }

    public static ArrayList<ITextComponent> createSkinTooltip(ItemStack itemStack) {
        boolean isItemOwner = ABI.is(itemStack, (Item)ModItems.SKIN.get());
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            if (isItemOwner) {
                tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinInvalidItem", new Object[0]));
            }
            return tooltip;
        }
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.TOOLTIP);
        if (bakedSkin == null) {
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skindownloading", descriptor.getIdentifier()));
            return tooltip;
        }
        Skin skin = bakedSkin.getSkin();
        SkinOptions options = descriptor.getOptions();
        SkinUsedCounter counter = bakedSkin.getUsedCounter();
        if (!isItemOwner) {
            if (options.contains(SkinOptions.TooltipFlags.HAS_SKIN)) {
                tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.hasSkin", new Object[0]));
            }
            if (options.contains(SkinOptions.TooltipFlags.NAME) && Strings.isNotBlank((String)skin.getCustomName())) {
                tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinName", skin.getCustomName().trim()));
            }
        }
        if (isItemOwner && options.contains(SkinOptions.TooltipFlags.FLAVOUR) && Strings.isNotBlank((String)skin.getFlavourText())) {
            tooltip.add((ITextComponent)TranslateUtils.title("item.armourers_workshop.rollover.flavour", skin.getFlavourText().trim()));
        }
        if (options.contains(SkinOptions.TooltipFlags.AUTHOR) && Strings.isNotBlank((String)skin.getAuthorName())) {
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinAuthor", skin.getAuthorName().trim()));
        }
        if (options.contains(SkinOptions.TooltipFlags.TYPE)) {
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinType", TranslateUtils.Name.of(skin.getType())));
        }
        if (!isItemOwner && options.contains(SkinOptions.TooltipFlags.FLAVOUR) && Strings.isNotBlank((String)skin.getFlavourText())) {
            tooltip.add((ITextComponent)TranslateUtils.title("item.armourers_workshop.rollover.flavour", skin.getFlavourText().trim()));
        }
        if (ModDebugger.tooltip && !Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinHoldShiftForInfo", new Object[0]));
        }
        if (ModDebugger.tooltip && Screen.func_231173_s_()) {
            String totals = String.format("%d/%d/%d/%d", counter.getCubeTotal(SkinCubeTypes.SOLID), counter.getCubeTotal(SkinCubeTypes.GLOWING), counter.getCubeTotal(SkinCubeTypes.GLASS), counter.getCubeTotal(SkinCubeTypes.GLASS_GLOWING));
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinIdentifier", descriptor.getIdentifier()));
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinTotalCubes", totals));
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinDyeCount", counter.getDyeTotal()));
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinMarkerCount", counter.getMarkerTotal()));
            if (skin.getPaintData() != null) {
                tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinPaintData", "64x32"));
            }
            if (ModDebugger.properties && !skin.getProperties().isEmpty()) {
                tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinProperties", new Object[0]));
                for (String prop : skin.getProperties().getPropertiesList()) {
                    tooltip.add((ITextComponent)TranslatableProvider.literal(ITextComponent.class, " " + prop));
                }
            }
        }
        if (options.contains(SkinOptions.TooltipFlags.OPEN_WARDROBE) && isItemOwner && skin.getType() instanceof ISkinEquipmentType) {
            ITextComponent keyName = ModKeyBindings.OPEN_WARDROBE_KEY.getKeyName();
            tooltip.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinOpenWardrobe", keyName));
        }
        return tooltip;
    }

    public static void gatherSkinTooltip(ItemStack itemStack, List<ITextComponent> tooltips, ITooltipFlag flags) {
        ArrayList<ITextComponent> newTooltips = ItemTooltipManager.createSkinTooltip(itemStack);
        if (newTooltips.isEmpty()) {
            return;
        }
        if (flags.func_194127_a()) {
            String registryName = RegistryManager.getKey(itemStack.func_77973_b()).toString();
            for (int index = tooltips.size(); index > 0; --index) {
                ITextComponent text = tooltips.get(index - 1);
                if (!registryName.equals(text.getString())) continue;
                tooltips.addAll(index - 1, newTooltips);
                return;
            }
        }
        tooltips.addAll(newTooltips);
    }

    public static void renderSkinTooltip(ItemStack itemStack, CGRect frame, float screenWidth, float screenHeight, CGGraphicsContext context) {
        float dy;
        float dx;
        if (!ModConfig.Client.skinPreEnabled) {
            return;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinOptions options = descriptor.getOptions();
        if (!options.contains(SkinOptions.TooltipFlags.PREVIEW)) {
            return;
        }
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.TOOLTIP);
        if (bakedSkin == null) {
            return;
        }
        float size = ModConfig.Client.skinPreSize;
        if (ModConfig.Client.skinPreLocFollowMouse) {
            dx = frame.getX() - 28.0f - size;
            dy = frame.getY() - 4.0f;
            if (frame.getX() < context.state().mousePos().getX()) {
                dx = frame.getX() + frame.getWidth() + 28.0f;
            }
            dy = MathUtils.clamp(dy, 0.0f, screenHeight - size);
        } else {
            dx = MathUtils.ceil((double)(screenWidth - size) * ModConfig.Client.skinPreLocHorizontal);
            dy = MathUtils.ceil((double)(screenHeight - size) * ModConfig.Client.skinPreLocVertical);
        }
        if (ModConfig.Client.skinPreDrawBackground) {
            context.drawTilableImage(ModTextures.GUI_PREVIEW, dx, dy, size, size, 0.0f, 0.0f, 62.0f, 62.0f, 4.0f, 4.0f, 4.0f, 4.0f, 400.0f);
        }
        ColorScheme colorScheme = descriptor.getColorScheme();
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        ExtendedItemRenderer.renderSkinInTooltip(bakedSkin, colorScheme, itemStack, dx, dy, 500.0f, size, size, 30.0f, 45.0f, 0.0f, 0.0f, 0xF000F0, context.state().ctm(), (IRenderTypeBuffer)buffers);
        buffers.func_228461_a_();
    }
}

