/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge;

import extensions.net.minecraft.core.Registry.ModEventBusProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class NotificationCenterImpl {
    private static final HashMap<Class<?>, ArrayList<?>> LISTENERS = new HashMap();

    public static <E extends Event> void observer(Class<E> clazz, Consumer<E> handler) {
        NotificationCenterImpl.observer(clazz, handler, (E event) -> event);
    }

    public static <E extends Event, T> void observer(Class<E> clazz, Consumer<T> handler, Function<E, T> transform) {
        ArrayList handlers = (ArrayList)ObjectUtils.unsafeCast(LISTENERS.computeIfAbsent(clazz, key -> {
            ArrayList queue = new ArrayList();
            Consumer<Event> listener = event -> queue.forEach(element -> element.accept(transform.apply(event)));
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, clazz, listener);
            if (ModEventBusProvider.isModEvent(Registry.class, clazz)) {
                FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, clazz, listener);
            }
            return queue;
        }));
        handlers.add(handler);
    }

    public static <E extends GenericEvent<? extends F>, F> void observer(Class<E> clazz, Class<F> genericClazz, Consumer<E> handler) {
        NotificationCenterImpl.observer(clazz, genericClazz, handler, event -> event);
    }

    public static <E extends GenericEvent<? extends F>, F, T> void observer(Class<E> clazz, Class<F> genericClazz, Consumer<T> handler, Function<E, T> transform) {
        ArrayList handlers = (ArrayList)ObjectUtils.unsafeCast(LISTENERS.computeIfAbsent(clazz, key -> {
            ArrayList queue = new ArrayList();
            Consumer<GenericEvent> listener = event -> queue.forEach(element -> element.accept(transform.apply(event)));
            MinecraftForge.EVENT_BUS.addGenericListener(genericClazz, EventPriority.NORMAL, false, clazz, listener);
            if (ModEventBusProvider.isModEvent(Registry.class, clazz)) {
                FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(genericClazz, EventPriority.NORMAL, false, clazz, listener);
            }
            return queue;
        }));
        handlers.add(handler);
    }
}

