/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.config.IConfigBuilder;
import moe.plushie.armourers_workshop.api.config.IConfigSpec;
import moe.plushie.armourers_workshop.api.config.IConfigValue;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigBuilderImpl {
    public static void reloadSpec(IConfigSpec spec, ForgeConfigSpec forgeSpec) {
        SpecProxy proxy = ObjectUtils.safeCast(spec, SpecProxy.class);
        if (proxy != null && proxy.spec == forgeSpec) {
            proxy.reload();
        }
    }

    public static IConfigSpec createClientSpec() {
        return ConfigBuilderImpl.createSpec(ModConfig.Type.CLIENT, proxy -> new ModConfigSpec.Client((BuilderProxy)proxy){
            final /* synthetic */ BuilderProxy val$proxy;
            {
                this.val$proxy = builderProxy;
            }

            @Override
            public IConfigBuilder builder() {
                return this.val$proxy;
            }
        });
    }

    public static IConfigSpec createCommonSpec() {
        return ConfigBuilderImpl.createSpec(ModConfig.Type.COMMON, proxy -> new ModConfigSpec.Common((BuilderProxy)proxy){
            final /* synthetic */ BuilderProxy val$proxy;
            {
                this.val$proxy = builderProxy;
            }

            @Override
            public IConfigBuilder builder() {
                return this.val$proxy;
            }
        });
    }

    private static <T extends IConfigBuilder> IConfigSpec createSpec(ModConfig.Type type, Function<BuilderProxy, T> applier) {
        Pair pair = new ForgeConfigSpec.Builder().configure(builder -> (IConfigBuilder)applier.apply(new BuilderProxy((ForgeConfigSpec.Builder)builder)));
        IConfigSpec spec = ((IConfigBuilder)pair.getKey()).build();
        if (spec instanceof SpecProxy) {
            SpecProxy proxy = (SpecProxy)spec;
            proxy.spec = (ForgeConfigSpec)pair.getValue();
            proxy.type = type.extension();
        }
        ModLoadingContext.get().registerConfig(type, (ForgeConfigSpec)pair.getValue());
        return spec;
    }

    public static class SpecProxy
    implements IConfigSpec {
        private String type = "";
        private ForgeConfigSpec spec;
        private Map<String, Object> snapshot;
        private final ArrayList<Runnable> listeners = new ArrayList();
        private final HashMap<String, ValueProxy<Object>> values;

        public SpecProxy(HashMap<String, ValueProxy<Object>> values) {
            this.values = values;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            this.values.forEach((key, value) -> {
                if (value.getter != null) {
                    fields.put((String)key, value.getter.get());
                }
            });
            return fields;
        }

        @Override
        public void apply(Map<String, Object> snapshot) {
            this.snapshot = snapshot;
            if (this.snapshot == null) {
                this.reload();
                return;
            }
            ModLog.debug("apply {} snapshot from server", this.type);
            snapshot.forEach((key, object) -> {
                ValueProxy<Object> value = this.values.get(key);
                if (value != null && value.setter != null) {
                    value.setter.accept(object);
                }
            });
            this.setChanged();
        }

        @Override
        public void reload() {
            if (this.snapshot != null) {
                return;
            }
            ModLog.debug("apply {} changes from spec", this.type);
            this.values.forEach((key, value) -> {
                if (value.setter != null) {
                    value.setter.accept(value.read());
                }
            });
            this.setChanged();
        }

        @Override
        public void save() {
            if (this.snapshot != null) {
                return;
            }
            ModLog.debug("save {} changes into spec", this.type);
            this.values.forEach((key, value) -> {
                if (value.getter != null) {
                    value.write(value.getter.get());
                }
            });
            if (this.spec != null) {
                this.spec.save();
                this.setChanged();
            }
        }

        @Override
        public void notify(Runnable action) {
            this.listeners.add(action);
        }

        private void setChanged() {
            this.listeners.forEach(Runnable::run);
        }
    }

    public static class BuilderProxy
    implements IConfigBuilder {
        String root = "";
        HashMap<String, ValueProxy<Object>> values = new HashMap();
        ForgeConfigSpec.Builder builder;

        BuilderProxy(ForgeConfigSpec.Builder builder) {
            this.builder = builder;
        }

        @Override
        public IConfigValue<Boolean> define(String path, boolean defaultValue, String ... description) {
            return this.put(path, (ForgeConfigSpec.ConfigValue)this.builder.comment(description).define(path, defaultValue));
        }

        @Override
        public IConfigValue<Integer> defineInRange(String path, int defaultValue, int min, int max, String ... description) {
            return this.put(path, (ForgeConfigSpec.ConfigValue)this.builder.comment(description).defineInRange(path, defaultValue, min, max));
        }

        @Override
        public IConfigValue<Double> defineInRange(String path, double defaultValue, double min, double max, String ... description) {
            return this.put(path, (ForgeConfigSpec.ConfigValue)this.builder.comment(description).defineInRange(path, defaultValue, min, max));
        }

        @Override
        public <T> IConfigValue<List<? extends T>> defineList(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator, String ... description) {
            return this.put(path, this.builder.comment(description).defineList(path, defaultValue, elementValidator));
        }

        @Override
        public void defineCategory(String name, String description, Runnable runnable) {
            String oldRoot = this.root;
            this.builder.comment(description);
            this.builder.push(name);
            this.root = this.root + name + ".";
            runnable.run();
            this.root = oldRoot;
            this.builder.pop();
        }

        @Override
        public IConfigBuilder builder() {
            return this;
        }

        @Override
        public IConfigSpec build() {
            return new SpecProxy(this.values);
        }

        private <T> IConfigValue<T> put(String path, ForgeConfigSpec.ConfigValue<T> value) {
            ValueProxy<T> proxy = new ValueProxy<T>(path, value);
            this.values.put(this.root + path, (ValueProxy)ObjectUtils.unsafeCast(proxy));
            return proxy;
        }
    }

    public static class ValueProxy<T>
    implements IConfigValue<T> {
        protected final String path;
        protected final ForgeConfigSpec.ConfigValue<T> configValue;
        protected Consumer<T> setter;
        protected Supplier<T> getter;

        public ValueProxy(String path, ForgeConfigSpec.ConfigValue<T> configValue) {
            this.path = path;
            this.configValue = configValue;
        }

        @Override
        public T read() {
            return (T)this.configValue.get();
        }

        @Override
        public void write(T value) {
            this.configValue.set(value);
        }

        @Override
        public void bind(Consumer<T> setter, Supplier<T> getter) {
            this.setter = setter;
            this.getter = getter;
        }
    }
}

