/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.action.NamedUserAction;
import moe.plushie.armourers_workshop.builder.data.undo.action.SetBlockAction;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public final class BlockUtils {
    private static final ThreadLocal<Map<TileEntity, Runnable>> pending = ThreadLocal.withInitial(() -> null);

    public static void beginCombiner() {
        Map<TileEntity, Runnable> queue = pending.get();
        if (queue == null) {
            pending.set(new IdentityHashMap());
        }
    }

    public static <T extends TileEntity> void combine(T blockEntity, Runnable handler) {
        Map<TileEntity, Runnable> queue = pending.get();
        if (queue == null) {
            handler.run();
            blockEntity.func_70296_d();
            return;
        }
        queue.put(blockEntity, handler);
    }

    public static void snapshot(IWorld level, BlockPos blockPos, BlockState blockState, CompoundNBT tag, PlayerEntity player, ITextComponent reason) {
        if (level == null) {
            return;
        }
        NamedUserAction group = new NamedUserAction(reason);
        group.push(new SetBlockAction((World)level, blockPos, blockState, tag));
        UndoManager.of(player.func_110124_au()).push(group);
    }

    public static void endCombiner() {
        Map<TileEntity, Runnable> queue = pending.get();
        if (queue == null) {
            return;
        }
        queue.forEach((k, v) -> {
            v.run();
            k.func_70296_d();
        });
        pending.set(null);
    }

    public static void performBatch(Runnable handler) {
        try {
            BlockUtils.beginCombiner();
            handler.run();
        }
        finally {
            BlockUtils.endCombiner();
        }
    }

    public static ArrayList<BlockPos> findTouchingBlockFaces(World level, BlockPos pos, Direction facing, int radius, boolean restrictPlane) {
        ArrayList<BlockPos> blockFaces = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        HashSet<BlockPos> closedList = new HashSet<BlockPos>();
        BlockPos startPos = pos.func_177972_a(facing);
        openList.add(startPos);
        Direction[] sides = Direction.values();
        boolean first = true;
        while (!openList.isEmpty()) {
            BlockPos loc = (BlockPos)openList.remove(0);
            TileEntity blockEntity = level.func_175625_s(loc);
            if (blockEntity instanceof IPaintable) {
                if (!restrictPlane) {
                    blockFaces.add(loc);
                } else if (BlockUtils.samePlane(loc, pos, facing)) {
                    blockFaces.add(loc);
                }
            }
            for (Direction side : sides) {
                BlockPos sideLoc = loc.func_177972_a(side);
                if (closedList.contains(sideLoc)) continue;
                closedList.add(sideLoc);
                if (!(BlockUtils.getDistance(sideLoc, pos) < (double)radius & BlockUtils.hasPaintableBlock(level, sideLoc))) continue;
                openList.add(sideLoc);
            }
            if (closedList.size() <= 5000) continue;
            break;
        }
        return blockFaces;
    }

    public static double getDistance(BlockPos src, BlockPos dst) {
        double d0 = src.func_177958_n() - dst.func_177958_n();
        double d1 = src.func_177956_o() - dst.func_177956_o();
        double d2 = src.func_177952_p() - dst.func_177952_p();
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    private static boolean hasPaintableBlock(World level, BlockPos pos) {
        for (int ix = 0; ix < 3; ++ix) {
            for (int iy = 0; iy < 3; ++iy) {
                for (int iz = 0; iz < 3; ++iz) {
                    TileEntity stateValid = level.func_175625_s(pos.func_177982_a(ix - 1, iy - 1, iz - 1));
                    if (!(stateValid instanceof IPaintable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean samePlane(BlockPos src, BlockPos dst, Direction direction) {
        if (!(direction.func_82601_c() != 0 && src.func_177958_n() != dst.func_177958_n() || direction.func_96559_d() != 0 && src.func_177956_o() != dst.func_177956_o())) {
            return direction.func_82599_e() == 0 || src.func_177952_p() == dst.func_177952_p();
        }
        return false;
    }
}

