/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.mojang.authlib.GameProfile;
import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.common.IContainerLevelAccess;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.common.IPlayerDataSerializer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.Strings;

public class DataSerializers {
    public static final IEntitySerializer<CompoundNBT> COMPOUND_TAG = DataSerializers.of(net.minecraft.network.datasync.DataSerializers.field_192734_n);
    public static final IEntitySerializer<Integer> INT = DataSerializers.of(net.minecraft.network.datasync.DataSerializers.field_187192_b);
    public static final IEntitySerializer<String> STRING = DataSerializers.of(net.minecraft.network.datasync.DataSerializers.field_187194_d);
    public static final IEntitySerializer<Boolean> BOOLEAN = DataSerializers.of(net.minecraft.network.datasync.DataSerializers.field_187198_h);
    public static final IEntitySerializer<Float> FLOAT = DataSerializers.of(net.minecraft.network.datasync.DataSerializers.field_187193_c);
    public static final IEntitySerializer<Vector3d> VECTOR_3D = new IEntitySerializer<Vector3d>(){

        public void write(PacketBuffer buffer, Vector3d pos) {
            buffer.writeDouble(pos.func_82615_a());
            buffer.writeDouble(pos.func_82617_b());
            buffer.writeDouble(pos.func_82616_c());
        }

        public Vector3d read(PacketBuffer buffer) {
            return new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    };
    public static final IEntitySerializer<Vector3f> VECTOR_3F = new IEntitySerializer<Vector3f>(){

        public void write(PacketBuffer buffer, Vector3f pos) {
            buffer.writeFloat(pos.getX());
            buffer.writeFloat(pos.getY());
            buffer.writeFloat(pos.getZ());
        }

        public Vector3f read(PacketBuffer buffer) {
            return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final IEntitySerializer<IPaintColor> PAINT_COLOR = new IEntitySerializer<IPaintColor>(){

        public void write(PacketBuffer buffer, IPaintColor color) {
            buffer.writeInt(color.getRawValue());
        }

        public IPaintColor read(PacketBuffer buffer) {
            return PaintColor.of(buffer.readInt());
        }
    };
    public static final IEntitySerializer<PlayerTextureDescriptor> PLAYER_TEXTURE = new IEntitySerializer<PlayerTextureDescriptor>(){

        public void write(PacketBuffer buffer, PlayerTextureDescriptor descriptor) {
            buffer.func_150786_a(descriptor.serializeNBT());
        }

        public PlayerTextureDescriptor read(PacketBuffer buffer) {
            return new PlayerTextureDescriptor(buffer.func_150793_b());
        }
    };
    public static final IEntitySerializer<Exception> EXCEPTION = new IEntitySerializer<Exception>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(PacketBuffer buffer, Exception exception) {
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                boolean compress = ModConfig.Common.enableServerCompressesSkins;
                buffer.writeBoolean(compress);
                outputStream = this.createOutputStream(buffer, compress);
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(exception);
            }
            catch (Exception exception1) {
                try {
                    exception1.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(objectOutputStream, outputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(objectOutputStream, outputStream);
            }
            StreamUtils.closeQuietly(objectOutputStream, outputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception read(PacketBuffer buffer) {
            Exception exception;
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                boolean compress = buffer.readBoolean();
                inputStream = this.createInputStream(buffer, compress);
                objectInputStream = new ObjectInputStream(inputStream);
                exception = (Exception)objectInputStream.readObject();
            }
            catch (Exception exception2) {
                Exception exception3;
                try {
                    exception3 = exception2;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(objectInputStream, inputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(objectInputStream, inputStream);
                return exception3;
            }
            StreamUtils.closeQuietly(objectInputStream, inputStream);
            return exception;
        }

        public Exception copy(Exception value) {
            return value;
        }

        private InputStream createInputStream(PacketBuffer buffer, boolean compress) throws Exception {
            ByteBufInputStream inputStream = new ByteBufInputStream((ByteBuf)buffer);
            if (compress) {
                return new GZIPInputStream((InputStream)inputStream);
            }
            return inputStream;
        }

        private OutputStream createOutputStream(PacketBuffer buffer, boolean compress) throws Exception {
            ByteBufOutputStream outputStream = new ByteBufOutputStream((ByteBuf)buffer);
            if (compress) {
                return new GZIPOutputStream((OutputStream)outputStream);
            }
            return outputStream;
        }
    };
    public static final IPlayerDataSerializer<SkinWardrobe> ENTITY_WARDROBE = new IPlayerDataSerializer<SkinWardrobe>(){

        @Override
        public void write(PacketBuffer buffer, PlayerEntity player, SkinWardrobe wardrobe) {
            buffer.writeInt(wardrobe.getId());
            buffer.func_192572_a(wardrobe.getProfile().getRegistryName());
        }

        @Override
        public SkinWardrobe read(PacketBuffer buffer, PlayerEntity player) {
            if (player == null || PropertyProvider.getLevel((Entity)player) == null) {
                return null;
            }
            int entityId = buffer.readInt();
            Entity entity = PropertyProvider.getLevel((Entity)player).func_73045_a(entityId);
            if (entity == null) {
                for (PlayerEntity player1 : PropertyProvider.getLevel((Entity)player).func_217369_A()) {
                    if (player1.func_145782_y() != entityId) continue;
                    entity = player1;
                    break;
                }
            }
            SkinWardrobe wardrobe = SkinWardrobe.of(entity);
            EntityProfile serverProfile = ModEntityProfiles.getProfile(buffer.func_192575_l());
            if (wardrobe != null && serverProfile != null) {
                wardrobe.setProfile(serverProfile);
            }
            return wardrobe;
        }
    };
    public static final IPlayerDataSerializer<IContainerLevelAccess> WORLD_POS = new IPlayerDataSerializer<IContainerLevelAccess>(){

        @Override
        public void write(PacketBuffer buffer, PlayerEntity player, IContainerLevelAccess callable) {
            Optional pos1 = callable.func_221484_a((world, pos) -> pos);
            buffer.func_179255_a(pos1.orElse(BlockPos.field_177992_a));
        }

        @Override
        public IContainerLevelAccess read(PacketBuffer buffer, PlayerEntity player) {
            if (player == null || PropertyProvider.getLevel((Entity)player) == null) {
                return null;
            }
            BlockPos blockPos = buffer.func_179259_c();
            return IContainerLevelAccess.create(PropertyProvider.getLevel((Entity)player), blockPos, null);
        }
    };
    public static final IPlayerDataSerializer<ISkinType> SKIN_TYPE = new IPlayerDataSerializer<ISkinType>(){

        @Override
        public void write(PacketBuffer buffer, PlayerEntity player, ISkinType value) {
            buffer.func_180714_a(value.getRegistryName().toString());
        }

        @Override
        public ISkinType read(PacketBuffer buffer, PlayerEntity player) {
            return SkinTypes.byName(buffer.func_150789_c(Short.MAX_VALUE));
        }
    };
    public static final IPlayerDataSerializer<SkinProperties> SKIN_PROPERTIES = new IPlayerDataSerializer<SkinProperties>(){

        @Override
        public void write(PacketBuffer buffer, PlayerEntity player, SkinProperties value) {
            CompoundNBT nbt = new CompoundNBT();
            value.writeToNBT(nbt);
            buffer.func_150786_a(nbt);
        }

        @Override
        public SkinProperties read(PacketBuffer buffer, PlayerEntity player) {
            SkinProperties properties = new SkinProperties();
            CompoundNBT nbt = buffer.func_150793_b();
            if (nbt != null) {
                properties.readFromNBT(nbt);
            }
            return properties;
        }
    };
    private static final Random RANDOM = new Random();

    public static <T> IEntitySerializer<T> of(final IDataSerializer<T> serializer) {
        return new IEntitySerializer<T>(){

            @Override
            public T func_187159_a(PacketBuffer buffer) {
                return serializer.func_187159_a(buffer);
            }

            @Override
            public void func_187160_a(PacketBuffer buffer, T descriptor) {
                serializer.func_187160_a(buffer, descriptor);
            }
        };
    }

    public static void mirrorRotations(CompoundNBT source, String sourceKey, Rotations sourceDefaultValue, CompoundNBT target, String targetKey, Rotations targetDefaultValue) {
        Rotations rot = OptionalAPI.getOptionalRotations(source, sourceKey, sourceDefaultValue);
        rot = new Rotations(rot.func_179415_b(), -rot.func_179416_c(), -rot.func_179413_d());
        OptionalAPI.putOptionalRotations(target, targetKey, rot, targetDefaultValue);
    }

    public static GameProfile readGameProfile(CompoundNBT tag) {
        String name = null;
        UUID id = null;
        if (tag.func_150297_b("Name", 8)) {
            name = tag.func_74779_i("Name");
        }
        if (tag.func_186855_b("Id")) {
            id = tag.func_186857_a("Id");
        }
        try {
            return new GameProfile(id, name);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static CompoundNBT writeGameProfile(CompoundNBT tag, GameProfile value) {
        if (value == null) {
            return tag;
        }
        if (Strings.isNotBlank((String)value.getName())) {
            tag.func_74778_a("Name", value.getName());
        }
        if (value.getId() != null) {
            tag.func_186854_a("Id", value.getId());
        }
        return tag;
    }

    public static void dropContents(World level, BlockPos blockPos, IInventory container) {
        DataSerializers.dropContents(level, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), container);
    }

    public static void dropContents(World level, Entity entity, IInventory container) {
        DataSerializers.dropContents(level, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), container);
    }

    private static void dropContents(World level, double x, double y, double z, IInventory container) {
        for (int i = 0; i < container.func_70302_i_(); ++i) {
            DataSerializers.dropItemStack(level, x, y, z, container.func_70301_a(i));
        }
    }

    public static void dropContents(World level, BlockPos blockPos, NonNullList<ItemStack> itemStacks) {
        itemStacks.forEach(itemStack -> DataSerializers.dropItemStack(level, blockPos, itemStack));
    }

    public static void dropItemStack(World level, BlockPos blockPos, ItemStack itemStack) {
        DataSerializers.dropItemStack(level, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), itemStack);
    }

    public static void dropItemStack(World level, double x, double y, double z, ItemStack itemStack) {
        double d0 = EntityType.field_200765_E.func_220333_h();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + RANDOM.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + RANDOM.nextDouble() * d1;
        double d5 = Math.floor(z) + RANDOM.nextDouble() * d1 + d2;
        while (!itemStack.func_190926_b()) {
            ItemEntity itementity = new ItemEntity(level, d3, d4, d5, itemStack.func_77979_a(RANDOM.nextInt(21) + 10));
            float f = 0.05f;
            itementity.func_213293_j(RANDOM.nextGaussian() * (double)0.05f, RANDOM.nextGaussian() * (double)0.05f + (double)0.2f, RANDOM.nextGaussian() * (double)0.05f);
            level.func_217376_c((Entity)itementity);
        }
    }
}

