/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import moe.plushie.armourers_workshop.api.client.model.IModelPartPose;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class ModelPartPose
implements IModelPartPose {
    private final float x;
    private final float y;
    private final float z;
    private float xRot;
    private float yRot;
    private float zRot;

    public ModelPartPose(float x, float y, float z, float xRot, float yRot, float zRot) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.xRot = xRot;
        this.yRot = yRot;
        this.zRot = zRot;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public float getXRot() {
        return this.xRot;
    }

    @Override
    public float getYRot() {
        return this.yRot;
    }

    @Override
    public float getZRot() {
        return this.zRot;
    }

    @Override
    public void transform(IPoseStack poseStack) {
        if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            poseStack.translate(this.x, this.y, this.z);
        }
        if (this.zRot != 0.0f) {
            poseStack.rotate(Vector3f.ZP.rotation(this.zRot));
        }
        if (this.yRot != 0.0f) {
            poseStack.rotate(Vector3f.YP.rotation(this.yRot));
        }
        if (this.xRot != 0.0f) {
            poseStack.rotate(Vector3f.XP.rotation(this.xRot));
        }
    }

    @Override
    public void setRotations(IModelPartPose partPose) {
        this.xRot = partPose.getXRot();
        this.yRot = partPose.getYRot();
        this.zRot = partPose.getZRot();
    }
}

