/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import extensions.com.mojang.blaze3d.vertex.PoseStack.Transform;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.utils.math.OpenBoundingBox;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenOrientedBoundingBox;
import moe.plushie.armourers_workshop.utils.math.OpenTransformedBoundingBox;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShapeTesselator {
    public static void point(IVector3f origin, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.point(origin.getX(), origin.getY(), origin.getZ(), 1.0f, poseStack, buffers);
    }

    public static void point(IVector3f origin, float length, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.point(origin.getX(), origin.getY(), origin.getZ(), length, poseStack, buffers);
    }

    public static void point(float x, float y, float z, float length, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.point(x, y, z, length, length, length, poseStack, buffers);
    }

    public static void point(float x, float y, float z, float width, float height, float depth, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        Matrix4f pose = poseStack.func_227866_c_().func_227870_a_();
        Matrix3f normal = poseStack.func_227866_c_().func_227872_b_();
        float minX = x - width * 0.5f;
        float minY = y - height * 0.5f;
        float minZ = z - depth * 0.5f;
        float midX = x + 0.0f;
        float midY = y + 0.0f;
        float midZ = z + 0.0f;
        float maxX = x + width * 0.5f;
        float maxY = y + height * 0.5f;
        float maxZ = z + depth * 0.5f;
        IVertexBuilder lineBuilder = buffers.getBuffer(SkinRenderType.lines());
        lineBuilder.func_227888_a_(pose, minX, midY, midZ).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        lineBuilder.func_227888_a_(pose, maxX, midY, midZ).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        lineBuilder.func_227888_a_(pose, midX, minY, midZ).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        lineBuilder.func_227888_a_(pose, midX, maxY, midZ).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        lineBuilder.func_227888_a_(pose, midX, midY, minZ).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        lineBuilder.func_227888_a_(pose, midX, midY, maxZ).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
    }

    public static void vector(IVector3f origin, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.vector(origin.getX(), origin.getY(), origin.getZ(), 1.0f, poseStack, buffers);
    }

    public static void vector(IVector3f origin, float length, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.vector(origin.getX(), origin.getY(), origin.getZ(), length, poseStack, buffers);
    }

    public static void vector(float x, float y, float z, float length, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.vector(x, y, z, length, length, length, poseStack, buffers);
    }

    public static void vector(float x, float y, float z, float width, float height, float depth, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        Matrix4f pose = poseStack.func_227866_c_().func_227870_a_();
        Matrix3f normal = poseStack.func_227866_c_().func_227872_b_();
        float minX = x - width * 0.5f;
        float minY = y - height * 0.5f;
        float minZ = z - depth * 0.5f;
        float midX = x + 0.0f;
        float midY = y + 0.0f;
        float midZ = z + 0.0f;
        float maxX = x + width * 0.5f;
        float maxY = y + height * 0.5f;
        float maxZ = z + depth * 0.5f;
        float n = width * 0.03f;
        float m = height * 0.1f;
        IVertexBuilder lineBuilder = buffers.getBuffer(SkinRenderType.lines());
        lineBuilder.func_227888_a_(pose, minX, midY, midZ).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        lineBuilder.func_227888_a_(pose, maxX, midY, midZ).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        lineBuilder.func_227888_a_(pose, midX, minY, midZ).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        lineBuilder.func_227888_a_(pose, midX, maxY, midZ).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        lineBuilder.func_227888_a_(pose, midX, midY, minZ).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        lineBuilder.func_227888_a_(pose, midX, midY, maxZ).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        IVertexBuilder arrowBuilder = buffers.getBuffer(SkinRenderType.BLIT_COLOR);
        arrowBuilder.func_227888_a_(pose, maxX - 0.0f, midY + 0.0f, midZ - 0.0f).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY - n, midZ - n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY + n, midZ - n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - 0.0f, midY + 0.0f, midZ - 0.0f).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY - n, midZ + n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY + n, midZ + n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - 0.0f, midY + 0.0f, midZ - 0.0f).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY + n, midZ - n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY + n, midZ + n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - 0.0f, midY + 0.0f, midZ - 0.0f).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY - n, midZ - n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY - n, midZ + n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY - n, midZ - n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY + n, midZ - n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY + n, midZ + n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY + n, midZ + n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY - n, midZ + n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, maxX - m, midY - n, midZ - n).func_225586_a_(255, 0, 0, 255).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - 0.0f, maxY - 0.0f, midZ + 0.0f).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, maxY - m, midZ - n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, maxY - m, midZ + n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - 0.0f, maxY - 0.0f, midZ + 0.0f).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, maxY - m, midZ - n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, maxY - m, midZ + n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - 0.0f, maxY - 0.0f, midZ + 0.0f).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, maxY - m, midZ + n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, maxY - m, midZ + n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - 0.0f, maxY - 0.0f, midZ + 0.0f).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, maxY - m, midZ - n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, maxY - m, midZ - n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, maxY - m, midZ - n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, maxY - m, midZ + n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, maxY - m, midZ + n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, maxY - m, midZ + n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, maxY - m, midZ - n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, maxY - m, midZ - n).func_225586_a_(0, 255, 0, 255).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - 0.0f, midY + 0.0f, maxZ - 0.0f).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, midY - n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, midY + n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - 0.0f, midY + 0.0f, maxZ - 0.0f).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, midY - n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, midY + n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - 0.0f, midY + 0.0f, maxZ - 0.0f).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, midY + n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, midY + n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - 0.0f, midY + 0.0f, maxZ - 0.0f).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, midY - n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, midY - n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, midY - n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, midY + n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, midY + n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, midY + n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX + n, midY - n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        arrowBuilder.func_227888_a_(pose, midX - n, midY - n, maxZ - m).func_225586_a_(0, 0, 255, 255).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
    }

    public static void stroke(AxisAlignedBB rect, UIColor color, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.stroke((float)rect.field_72340_a, (float)rect.field_72338_b, (float)rect.field_72339_c, (float)rect.field_72336_d, (float)rect.field_72337_e, (float)rect.field_72334_f, color, poseStack, buffers);
    }

    public static void stroke(IRectangle3f rect, UIColor color, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.stroke(rect.getMinX(), rect.getMinY(), rect.getMinZ(), rect.getMaxX(), rect.getMaxY(), rect.getMaxZ(), color, poseStack, buffers);
    }

    public static void stroke(IRectangle3i rect, UIColor color, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.stroke(rect.getMinX(), rect.getMinY(), rect.getMinZ(), rect.getMaxX(), rect.getMaxY(), rect.getMaxZ(), color, poseStack, buffers);
    }

    public static void stroke(OpenBoundingBox aabb, UIColor color, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.stroke(aabb.getMinX(), aabb.getMinY(), aabb.getMinZ(), aabb.getMaxX(), aabb.getMaxY(), aabb.getMaxZ(), color, poseStack, buffers);
    }

    public static void stroke(OpenOrientedBoundingBox obb, UIColor color, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        poseStack.func_227860_a_();
        ABI.mulPose(poseStack, obb.getOrientation());
        ShapeTesselator.stroke(obb.getBoundingBox(), color, poseStack, buffers);
        poseStack.func_227865_b_();
    }

    public static void stroke(OpenTransformedBoundingBox tbb, UIColor color, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        poseStack.func_227860_a_();
        ABI.mulPoseMatrix(poseStack, tbb.getTransform());
        ABI.mulNormalMatrix(poseStack, new OpenMatrix3f(tbb.getTransform()));
        ShapeTesselator.stroke(tbb.getBoundingBox(), color, poseStack, buffers);
        poseStack.func_227865_b_();
    }

    public static void stroke(JointShape shape, UIColor color, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        poseStack.func_227860_a_();
        Rectangle3f rect = shape.bounds();
        Transform.applyTransform(poseStack, shape.transform());
        ShapeTesselator.stroke(rect, color, poseStack, buffers);
        poseStack.func_227861_a_((double)rect.getX(), (double)rect.getY(), (double)rect.getZ());
        for (JointShape shape1 : shape.children()) {
            ShapeTesselator.stroke(shape1, color, poseStack, buffers);
        }
        poseStack.func_227865_b_();
    }

    public static void stroke(float x0, float y0, float z0, float x1, float y1, float z1, UIColor color, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.fill(x0, y0, z0, x1, y1, z1, color, poseStack, buffers.getBuffer(SkinRenderType.lines()));
    }

    public static void fill(float x0, float y0, float z0, float x1, float y1, float z1, UIColor color, MatrixStack poseStack, IVertexBuilder builder) {
        Matrix4f pose = poseStack.func_227866_c_().func_227870_a_();
        Matrix3f normal = poseStack.func_227866_c_().func_227872_b_();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        builder.func_227888_a_(pose, x0, y0, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y0, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y0, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y1, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y0, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y0, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y0, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y1, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y1, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, -1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y1, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, -1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y1, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y1, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y1, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, -1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y0, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, -1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y0, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y0, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y0, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 0.0f, -1.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y0, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 0.0f, -1.0f).func_181675_d();
        builder.func_227888_a_(pose, x0, y1, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y1, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y0, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y1, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y1, z0).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(pose, x1, y1, z1).func_225586_a_(r, g, b, a).func_227887_a_(normal, 0.0f, 0.0f, 1.0f).func_181675_d();
    }
}

