/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.security.SecureRandom;

public class SkinUUID {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final char[] ALPHABET = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz1234567890".toCharArray();
    private final String value;

    public SkinUUID() {
        StringBuilder builder = new StringBuilder(10);
        long number = RANDOM.nextLong() & Long.MAX_VALUE;
        for (int i = 0; i < 10; ++i) {
            builder.append(ALPHABET[(int)(number % 62L)]);
            number /= 62L;
        }
        this.value = builder.reverse().toString();
    }

    public SkinUUID(String value) {
        this.value = value;
    }

    public static SkinUUID randomUUID() {
        return new SkinUUID();
    }

    public static String randomUUIDString() {
        return SkinUUID.randomUUID().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinUUID)) {
            return false;
        }
        SkinUUID skinUUID = (SkinUUID)o;
        return this.value.equals(skinUUID.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

