/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.InputManagerImpl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIView;
import java.util.Collection;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.data.ClamppedVector3f;
import moe.plushie.armourers_workshop.builder.entity.CameraEntity;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.Options.FOVSupport;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.math.OpenAxisAlignedBoundingBox;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenNearPlane;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.GameSettings;
import net.minecraft.entity.Entity;

public class AdvancedCameraPanel
extends UIView {
    private CGPoint startMousePos = CGPoint.ZERO;
    private final OpenVector3f origin = new OpenVector3f();
    private final OpenVector3f oldRotation = new OpenVector3f();
    private final OpenVector3f oldTranslate = new OpenVector3f();
    private final OpenVector3f lastZoom = new ClamppedVector3f(1.0f, 1.0f, 1.0f, 0.1f, 0.1f, 0.1f, 2.0f, 2.0f, 2.0f);
    private final OpenVector3f lastRotation = new ClamppedVector3f(0.0f, 0.0f, 0.0f, -90.0f, Float.NEGATIVE_INFINITY, 0.0f, 90.0f, Float.POSITIVE_INFINITY, 0.0f);
    private final OpenVector3f lastTranslate = new OpenVector3f(0.0f, 0.0f, 0.0f);
    private final GameSettings options;
    private final AdvancedBuilderBlockEntity blockEntity;
    private final CameraEntity cameraEntity = new CameraEntity();
    private Collection<Node> cachedTree;
    boolean moveMode = false;
    boolean rotationMode = false;

    public AdvancedCameraPanel(DocumentEditor editor) {
        super(CGRect.ZERO);
        this.options = EnvironmentManager.getClient().field_71474_y;
        this.blockEntity = editor.blockEntity();
    }

    public void connect() {
        this.cameraEntity.connect();
        this.reset();
    }

    public void disconnect() {
        this.reset();
        this.cameraEntity.disconnect();
    }

    public void reset() {
        this.origin.set(this.blockEntity.getRenderOrigin());
        this.lastRotation.set(0.0f, 0.0f, 0.0f);
        this.lastTranslate.set(0.0f, 0.0f, 0.0f);
        this.lastZoom.set(1.0f, 1.0f, 1.0f);
        this.applyCameraChanges();
    }

    @Override
    public void mouseDown(UIEvent event) {
        boolean bl = this.rotationMode = event.type() != UIEvent.Type.MOUSE_RIGHT_DOWN;
        if (InputManagerImpl.hasSpaceDown()) {
            this.rotationMode = !this.rotationMode;
        }
        this.moveMode = !this.rotationMode;
        this.startMousePos = event.locationInWindow();
        this.oldRotation.set(this.lastRotation);
        this.oldTranslate.set(this.lastTranslate);
    }

    @Override
    public void mouseUp(UIEvent event) {
        this.oldRotation.set(this.lastRotation);
        this.oldTranslate.set(this.lastTranslate);
    }

    @Override
    public void mouseDragged(UIEvent event) {
        CGPoint mousePos = event.locationInWindow();
        if (this.moveMode) {
            float dx = mousePos.x - this.startMousePos.x;
            float dy = mousePos.y - this.startMousePos.y;
            this.move(new OpenVector3f(dx, dy, 0.0f));
        }
        if (this.rotationMode) {
            this.rotation(mousePos);
        }
        this.applyCameraChanges();
    }

    @Override
    public void mouseWheel(UIEvent event) {
        this.zoom(event.delta().y());
    }

    @Override
    public void mouseMoved(UIEvent event) {
    }

    private void move(OpenVector3f delta) {
        CGRect window = this.bounds();
        OpenNearPlane plane = this.cameraEntity.getNearPlane();
        float near = FOVSupport.getCameraNear(this.options);
        float deltaX = -delta.x() / (window.width / 2.0f);
        float deltaY = delta.y() / (window.height / 2.0f);
        float deltaZ = near + delta.z();
        OpenVector3f d1 = plane.at(0.0f, 0.0f, -near);
        OpenVector3f d2 = plane.at(deltaX, deltaY, deltaZ);
        float x = this.oldTranslate.x() + d1.x() + d2.x();
        float y = this.oldTranslate.y() + d1.y() + d2.y();
        float z = this.oldTranslate.z() + d1.z() + d2.z();
        this.lastTranslate.set(x, y, z);
    }

    private void rotation(CGPoint mousePos) {
        CGRect window = this.bounds();
        float dx = (mousePos.y - this.startMousePos.y) / window.height;
        float dy = (mousePos.x - this.startMousePos.x) / window.width;
        float rx = this.oldRotation.x() + dx * 360.0f;
        float ry = this.oldRotation.y() + dy * 360.0f;
        this.lastRotation.set(rx, ry, 0.0f);
    }

    private void zoom(double delta) {
        float scale = this.lastZoom.x();
        if (delta < 0.0) {
            scale /= 0.99f;
        } else if (delta > 0.0) {
            scale *= 0.99f;
        }
        this.lastZoom.set(scale, scale, scale);
        this.applyCameraChanges();
    }

    public void applyCameraChanges() {
        float tx = this.lastTranslate.x();
        float ty = this.lastTranslate.y();
        float tz = this.lastTranslate.z();
        float rx = this.lastRotation.x();
        float ry = this.lastRotation.y();
        float rz = this.lastRotation.z();
        this.blockEntity.carmeOffset.set(tx, ty, tz);
        this.blockEntity.carmeRot.set(rx, ry, rz);
        this.cameraEntity.setZoom(this.lastZoom.z());
        PropertyProvider.setXRot((Entity)this.cameraEntity, rx);
        PropertyProvider.setYRot((Entity)this.cameraEntity, ry);
        this.cameraEntity.func_70107_b(this.origin.x() + tx, this.origin.y() + ty, this.origin.z() + tz);
        PropertyProvider.setOldPosAndRot((Entity)this.cameraEntity);
    }

    public static class Node {
        final OpenMatrix4f invMat;
        final BakedSkinPart part;
        final OpenAxisAlignedBoundingBox box;

        Node(BakedSkinPart part, OpenMatrix4f invMat) {
            this.part = part;
            this.invMat = invMat;
            this.box = part.renderShape().aabb();
        }
    }

    public static class Result {
        final BakedSkinPart part;
        float distance;

        Result(BakedSkinPart part, float distance) {
            this.part = part;
            this.distance = distance;
        }
    }
}

