/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBaseSetting;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerClearDialog;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerCopyDialog;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerReplaceDialog;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateArmourerPacket;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Constructor;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerBlockSetting
extends ArmourerBaseSetting {
    protected final ArmourerBlockEntity blockEntity;

    protected ArmourerBlockSetting(ArmourerMenu container) {
        super("armourer.blockUtils");
        this.blockEntity = (ArmourerBlockEntity)container.getBlockEntity();
    }

    @Override
    public void init() {
        super.init();
        UIButton clearBtn = new UIButton(new CGRect(10.0f, 20.0f, 70.0f, 20.0f));
        clearBtn.setTitle(this.getDisplayText("clear", new Object[0]), 7);
        clearBtn.setTitleColor(UIColor.WHITE, 7);
        clearBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        clearBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::clearAction);
        this.addSubview(clearBtn);
        UIButton copyBtn = new UIButton(new CGRect(10.0f, 45.0f, 70.0f, 20.0f));
        copyBtn.setTitle(this.getDisplayText("copy", new Object[0]), 7);
        copyBtn.setTitleColor(UIColor.WHITE, 7);
        copyBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        copyBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::copyAction);
        this.addSubview(copyBtn);
        UIButton replaceBtn = new UIButton(new CGRect(10.0f, 70.0f, 70.0f, 20.0f));
        replaceBtn.setTitle(this.getDisplayText("replace", new Object[0]), 7);
        replaceBtn.setTitleColor(UIColor.WHITE, 7);
        replaceBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        replaceBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::replaceAction);
        this.addSubview(replaceBtn);
    }

    private void clearAction(UIControl sender) {
        ArmourerClearDialog dialog = new ArmourerClearDialog(this.getPartTypes(true));
        dialog.setTitle(NSString.localizedString("armourer.dialog.clear.title", new Object[0]));
        dialog.showInView(this, () -> {
            if (dialog.isCancelled()) {
                return;
            }
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("Cubes", dialog.isClearBlocks());
            nbt.func_74757_a("Paints", dialog.isClearPaints());
            nbt.func_74757_a("Markers", dialog.isClearMarkers());
            nbt.func_74778_a("PartType", dialog.selectedPartType().registryName().toString());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_CLEAR.buildPacket(this.blockEntity, nbt));
        });
    }

    private void copyAction(UIControl sender) {
        ArmourerCopyDialog dialog = new ArmourerCopyDialog(this.getPartTypes(false));
        dialog.setTitle(NSString.localizedString("armourer.dialog.copy.title", new Object[0]));
        dialog.showInView(this, () -> {
            if (dialog.isCancelled()) {
                return;
            }
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("Mirror", dialog.isMirror());
            nbt.func_74757_a("Paints", dialog.isCopyPaintData());
            nbt.func_74778_a("Source", dialog.sourcePartType().registryName().toString());
            nbt.func_74778_a("Destination", dialog.destinationPartType().registryName().toString());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_COPY.buildPacket(this.blockEntity, nbt));
        });
    }

    private void replaceAction(UIControl sender) {
        ArmourerReplaceDialog dialog = new ArmourerReplaceDialog();
        dialog.setTitle(NSString.localizedString("armourer.dialog.replace.title", new Object[0]));
        dialog.showInView(this, () -> {
            ClientWorld level = EnvironmentManager.getClient().field_71441_e;
            if (dialog.isCancelled() || level == null) {
                return;
            }
            CompoundNBT source = new CompoundNBT();
            ItemStack selector = dialog.selector();
            if (selector.func_77973_b() instanceof IItemPaintable) {
                Constructor.save(selector, level.func_241828_r(), source);
            }
            CompoundNBT destination = new CompoundNBT();
            ItemStack applier = dialog.applier();
            if (applier.func_77973_b() instanceof IItemPaintable) {
                Constructor.save(applier, level.func_241828_r(), destination);
            }
            if (source.isEmpty() && destination.isEmpty()) {
                return;
            }
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("Source", (INBT)source);
            nbt.func_218657_a("Destination", (INBT)destination);
            nbt.func_74757_a("KeepColor", dialog.isKeepColor());
            nbt.func_74757_a("KeepPaintType", dialog.isKeepPaintType());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_REPLACE.buildPacket(this.blockEntity, nbt));
        });
    }

    public ArrayList<SkinPartType> getPartTypes(boolean usesAll) {
        SkinType skinType = this.blockEntity.skinType();
        SkinProperties skinProperties = this.blockEntity.skinProperties();
        ArrayList<SkinPartType> partTypes = new ArrayList<SkinPartType>();
        if (usesAll) {
            partTypes.add(0, SkinPartTypes.UNKNOWN);
        }
        if (skinType != SkinTypes.BLOCK) {
            partTypes.addAll(skinType.parts());
        } else if (skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue()) {
            partTypes.add(SkinPartTypes.BLOCK_MULTI);
        } else {
            partTypes.add(SkinPartTypes.BLOCK);
        }
        return partTypes;
    }
}

