/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.properties;

import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class DataProperty<T> {
    protected T value;
    protected Consumer<Boolean> editingObserver;
    protected final ArrayList<Consumer<T>> valueObservers = new ArrayList();

    public DataProperty() {
    }

    public DataProperty(T value) {
        this.value = value;
    }

    public void beginEditing() {
        if (this.editingObserver != null) {
            this.editingObserver.accept(true);
        }
    }

    public void endEditing() {
        if (this.editingObserver != null) {
            this.editingObserver.accept(false);
        }
    }

    public void set(T value) {
        if (Objects.equals(this.value, value)) {
            return;
        }
        this.value = value;
        this.valueObservers.forEach((Consumer<Consumer<T>>)((Consumer<Consumer>)it -> it.accept(value)));
    }

    public T get() {
        return this.value;
    }

    public T getOrDefault(T defaultValue) {
        if (this.value != null) {
            return this.value;
        }
        return defaultValue;
    }

    public void addObserver(Consumer<T> observer) {
        this.valueObservers.add(observer);
    }

    public void addEditingObserver(Consumer<Boolean> observer) {
        this.editingObserver = observer;
    }
}

