/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.action.NamedUserAction;
import moe.plushie.armourers_workshop.builder.other.CubeChanges;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CubeChangesCollector {
    private final World level;
    private final CubeWrapper wrapper;
    private final ArrayList<CubeChanges> allChanges = new ArrayList();

    public CubeChangesCollector(World level) {
        this.level = level;
        this.wrapper = new CubeWrapper(level, this.allChanges::add);
    }

    public void submit(ITextComponent name, PlayerEntity player) {
        this.wrapper.setBlockPos(null);
        if (this.allChanges.isEmpty()) {
            return;
        }
        NamedUserAction group = new NamedUserAction(name);
        this.allChanges.forEach(group::push);
        UndoManager.of(player.func_110124_au()).push(group.apply());
    }

    public CubeWrapper cubeAtPos(BlockPos pos) {
        this.wrapper.setBlockPos(pos);
        return this.wrapper;
    }

    public World level() {
        return this.level;
    }

    public int total() {
        return this.allChanges.size();
    }
}

