/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDeltaTracker;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.CustomRiddingProvider;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentPose;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentTypes;
import moe.plushie.armourers_workshop.init.event.client.RenderFrameEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.horse.HorseEntity;

public class AbstractVehicleUpdater {
    private static final AbstractVehicleUpdater INSTANCE = new AbstractVehicleUpdater();
    private final Int2ObjectMap<Entity> entities = new Int2ObjectOpenHashMap();
    private Int2ObjectMap<Entity> active;

    private AbstractVehicleUpdater() {
        EventBus.register(RenderFrameEvent.Pre.class, event -> this.update(event.getDeltaTracker()));
    }

    public static AbstractVehicleUpdater getInstance() {
        return INSTANCE;
    }

    public void submit(Entity entity) {
        this.active = this.entities;
        this.entities.put(entity.func_145782_y(), (Object)entity);
    }

    private void update(AbstractDeltaTracker delta) {
        if (this.active == null) {
            return;
        }
        ArrayList<Entity> oldValue = new ArrayList<Entity>((Collection<Entity>)this.entities.values());
        this.active = null;
        this.entities.clear();
        oldValue.forEach(it -> this.apply((Entity)it, delta.getPartialTick((Entity)it)));
    }

    private void apply(Entity entity, float partialTicks) {
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        List passengers = entity.func_184188_bt();
        for (int index = 0; index < passengers.size(); ++index) {
            SkinAttachmentPose attachmentPose = renderData.getAttachmentPose(SkinAttachmentTypes.RIDING, index);
            if (attachmentPose == null) continue;
            Entity passenger = (Entity)passengers.get(index);
            this.apply(entity, partialTicks, index, passenger, attachmentPose);
        }
    }

    private void apply(Entity entity, float partialTicks, int index, Entity passenger, SkinAttachmentPose pose) {
        float scale = this.getRiddingScale(entity);
        OpenMatrix4f mat = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
        mat.rotate(OpenVector3f.YP.rotationDegrees(180.0f - entity.func_195046_g(partialTicks)));
        mat.scale(-1.0f, -1.0f, 1.0f);
        mat.scale(scale, scale, scale);
        mat.translate(0.0f, -1.501f, 0.0f);
        mat.scale(0.0625f, 0.0625f, 0.0625f);
        mat.multiply(pose.pose());
        OpenVector3f offset = OpenVector3f.ZERO.transforming(mat);
        CustomRiddingProvider.setCustomRidding(entity, index, offset);
        double tx = passenger.func_226277_ct_();
        double ty = passenger.func_226278_cu_();
        double tz = passenger.func_226281_cx_();
        entity.func_184232_k(passenger);
        double dx = passenger.func_226277_ct_() - tx;
        double dy = passenger.func_226278_cu_() - ty;
        double dz = passenger.func_226281_cx_() - tz;
        passenger.field_70169_q += dx;
        passenger.field_70167_r += dy;
        passenger.field_70166_s += dz;
        passenger.field_70142_S += dx;
        passenger.field_70137_T += dy;
        passenger.field_70136_U += dz;
    }

    private float getRiddingScale(Entity entity) {
        if (entity instanceof HorseEntity) {
            return 1.1f;
        }
        return 1.0f;
    }
}

