/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.model;

import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.client.model.IModelPartCollector;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractSkinnableModel;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraft.client.renderer.model.ModelRenderer;

public class AbstractModelCollector {
    private static final Map<Class<?>, Map<String, String>> FIXER = Collections.immutableMap(builder -> {
        builder.put(AbstractSkinnableModel.ILLAGER, Collections.immutableMap(builder2 -> {
            builder2.put((Object)"root.head", (Object)"parts[0]");
            builder2.put((Object)"root.body", (Object)"parts[1]");
            builder2.put((Object)"root.left_leg", (Object)"parts[2]");
            builder2.put((Object)"root.right_leg", (Object)"parts[3]");
            builder2.put((Object)"root.arms", (Object)"parts[4]");
            builder2.put((Object)"root.right_arm", (Object)"parts[5]");
            builder2.put((Object)"root.left_arm", (Object)"parts[6]");
            builder2.put((Object)"root.head.hat", (Object)"parts[0].children[0]");
        }));
        builder.put(AbstractSkinnableModel.VILLAGER, Collections.immutableMap(builder2 -> {
            builder2.put((Object)"root.head.hat", (Object)"parts[0].children[0]");
            builder2.put((Object)"root.head.hat.hat_rim", (Object)"parts[0].children[0].children[0]");
            builder2.put((Object)"root.head", (Object)"parts[0]");
            builder2.put((Object)"root.head.nose", (Object)"parts[0].children[1]");
            builder2.put((Object)"root.body", (Object)"parts[1]");
            builder2.put((Object)"root.right_leg", (Object)"parts[2]");
            builder2.put((Object)"root.left_leg", (Object)"parts[3]");
            builder2.put((Object)"root.arms", (Object)"parts[4]");
            builder2.put((Object)"root.body.jacket", (Object)"parts[1].children[0]");
        }));
        builder.put(AbstractSkinnableModel.IRON_GOLEM, Collections.immutableMap(builder2 -> {
            builder2.put((Object)"root.head", (Object)"parts[0]");
            builder2.put((Object)"root.body", (Object)"parts[1]");
            builder2.put((Object)"root.right_leg", (Object)"parts[2]");
            builder2.put((Object)"root.left_leg", (Object)"parts[3]");
            builder2.put((Object)"root.right_arm", (Object)"parts[4]");
            builder2.put((Object)"root.left_arm", (Object)"parts[5]");
        }));
        builder.put(AbstractSkinnableModel.CREEPER, Collections.immutableMap(builder2 -> builder2.put((Object)"root.head", (Object)"parts[0]")));
        builder.put(AbstractSkinnableModel.HORSE, Collections.immutableMap(builder2 -> builder2.put((Object)"bodyParts[0].tail", (Object)"bodyParts[0].children[0]")));
    });

    public static void collect(String root, Iterable<ModelRenderer> parts, Map<String, ModelRenderer> collector) {
        int i = 0;
        for (ModelRenderer part : parts) {
            String name = String.format("%s[%d]", root, i++);
            collector.put(name, part);
            if (!(part instanceof IModelPartCollector)) continue;
            IModelPartCollector provider = (IModelPartCollector)part;
            LinkedHashMap<String, ModelRenderer> child = new LinkedHashMap<String, ModelRenderer>();
            provider.aw2$collect(child);
            child.forEach((key, value) -> collector.put(name + "." + key, (ModelRenderer)value));
        }
    }

    public static Map<String, String> apply(Class<?> clazz, Map<String, String> mapper) {
        Map<String, String> fixer = FIXER.get(clazz);
        if (fixer == null) {
            return mapper;
        }
        LinkedHashMap<String, String> fixedMapper = new LinkedHashMap<String, String>();
        mapper.forEach((key, value) -> fixedMapper.put((String)key, fixer.getOrDefault(value, (String)value)));
        return fixedMapper;
    }
}

