/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.mixin;

import java.util.function.Function;
import moe.plushie.armourers_workshop.core.client.other.FindableSkinManager;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ModelBakeryMixin {

    @Mixin(value={ModelBakery.class})
    public static class BakeryPatch {
        @Inject(method={"loadBlockModel"}, at={@At(value="HEAD")}, cancellable=true)
        private void aw2$loadBlockModel(ResourceLocation location, CallbackInfoReturnable<BlockModel> cir) {
            BlockModel unbakedModel = FindableSkinManager.getInstance().loadSkinModel(location);
            if (unbakedModel != null) {
                cir.setReturnValue((Object)unbakedModel);
            }
        }
    }

    @Mixin(value={BlockModel.class})
    public static class ModelPatch {
        @Inject(method={"bake(Lnet/minecraft/client/resources/model/ModelBakery;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="RETURN")})
        private void aw2$bake(ModelBakery modelBakery, Function<RenderMaterial, TextureAtlasSprite> function, IModelTransform modelState, ResourceLocation resourceLocation, CallbackInfoReturnable<IBakedModel> cir) {
            BlockModel unbakedModel = (BlockModel)BlockModel.class.cast(this);
            IBakedModel bakedModel = (IBakedModel)cir.getReturnValue();
            FindableSkinManager.getInstance().bakeSkinModel(unbakedModel, bakedModel);
        }
    }
}

