/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.armature.ArmatureSerializers;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerBuilder;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.entity.EntityType;

public abstract class ArmatureTransformerManager {
    private final HashMap<IResourceLocation, ArmatureTransformerBuilder> pendingBuilders = new HashMap();
    private final HashMap<IResourceLocation, ArmatureTransformerBuilder> namedBuilders = new HashMap();
    private final HashMap<IEntityTypeProvider<?>, ArrayList<ArmatureTransformerBuilder>> entityBuilders = new HashMap();
    private final HashMap<Class<?>, ArrayList<ArmatureTransformerBuilder>> modelBuilders = new HashMap();
    private int version = 0;

    protected abstract ArmatureTransformerBuilder createBuilder(IResourceLocation var1);

    public void clear() {
        this.pendingBuilders.clear();
    }

    public void append(IResourceLocation registryName, IODataObject object) {
        ArmatureTransformerBuilder builder = this.createBuilder(registryName);
        this.pendingBuilders.put(registryName, builder);
        builder.load(object);
    }

    public void freeze() {
        HashMap<IResourceLocation, ArmatureTransformerBuilder> builders1 = new HashMap<IResourceLocation, ArmatureTransformerBuilder>();
        this.pendingBuilders.forEach((name, builder) -> {
            ArrayList<ArmatureTransformerBuilder> chain = new ArrayList<ArmatureTransformerBuilder>();
            ArmatureTransformerBuilder nextBuilder = builder;
            while (nextBuilder.parent() != null) {
                ArmatureTransformerBuilder parent = this.pendingBuilders.get(nextBuilder.parent());
                if (parent == null) {
                    ModLog.warn("Can't found parent '{}'", nextBuilder.parent());
                    break;
                }
                chain.add(parent);
                nextBuilder = parent;
            }
            if (!chain.isEmpty()) {
                builder.resolve(chain);
            }
            builders1.put((IResourceLocation)name, (ArmatureTransformerBuilder)builder);
        });
        this.pendingBuilders.clear();
        builders1.forEach((name, builder) -> {
            builder.entities().forEach((Consumer<IEntityTypeProvider<?>>)((Consumer<IEntityTypeProvider>)entityType -> this.entityBuilders.computeIfAbsent((IEntityTypeProvider<?>)entityType, it -> new ArrayList()).add(builder)));
            builder.models().forEach(model -> {
                Class<?> modelClazz = ArmatureSerializers.getClass(model);
                if (modelClazz == null) {
                    ModLog.warn("Can't found model class '{}'", model);
                    return;
                }
                this.modelBuilders.computeIfAbsent(modelClazz, k -> new ArrayList()).add(builder);
            });
            this.namedBuilders.put((IResourceLocation)name, (ArmatureTransformerBuilder)builder);
        });
        ++this.version;
    }

    public ArmatureTransformer getTransformer(EntityType<?> entityType, EntityProfile entityProfile, IModel entityModel) {
        Object resultBuilders;
        ArrayList classes = new ArrayList();
        ArrayList<ArmatureTransformerBuilder> finalBuilders = new ArrayList<ArmatureTransformerBuilder>();
        if (entityModel != null) {
            this.modelBuilders.forEach((clazz, builders) -> {
                if (clazz.isAssignableFrom(entityModel.type())) {
                    for (Class parent : classes) {
                        if (!clazz.isAssignableFrom(parent)) continue;
                        return;
                    }
                    classes.add(clazz);
                    finalBuilders.addAll((Collection<ArmatureTransformerBuilder>)builders);
                }
            });
        }
        if (entityType != null && (resultBuilders = ArmatureTransformerManager.find(this.entityBuilders, entityType, Supplier::get)) != null) {
            finalBuilders.addAll((Collection<ArmatureTransformerBuilder>)resultBuilders);
        }
        if (entityProfile != null) {
            for (IResourceLocation registryName : entityProfile.transformers()) {
                ArmatureTransformerBuilder builder = this.namedBuilders.get(registryName);
                if (builder == null) continue;
                finalBuilders.add(builder);
            }
        }
        if (!finalBuilders.isEmpty()) {
            ArmatureTransformerContext context = new ArmatureTransformerContext(entityType, entityModel);
            return ((ArmatureTransformerBuilder)finalBuilders.get(finalBuilders.size() - 1)).build(context);
        }
        return null;
    }

    public int version() {
        return this.version;
    }

    public static <K, V, R> V find(Map<K, V> map, R req, Function<K, R> resolver) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!req.equals(resolver.apply(entry.getKey()))) continue;
            return entry.getValue();
        }
        return null;
    }
}

