/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation.handler;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.resources.sounds.SoundInstance.Constructor;
import moe.plushie.armourers_workshop.core.client.sound.SmartSoundManager;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationPoint;
import moe.plushie.armourers_workshop.core.skin.molang.core.ExecutionContext;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.BlockEntitySelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EntitySelectorImpl;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundData;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundProperties;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OptimizedExpression;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.SoundEvent;

public class AnimationSoundHandler
implements OptimizedExpression<Object> {
    private final String name;
    private final SoundEvent soundEvent;
    private final float volume;
    private final float pitch;

    public AnimationSoundHandler(SkinAnimationPoint.Sound sound) {
        SkinSoundData soundProvider = sound.provider();
        SkinSoundProperties soundProperties = soundProvider.properties();
        this.name = sound.effect();
        this.volume = soundProperties.volume();
        this.pitch = soundProperties.pitch();
        this.soundEvent = SmartSoundManager.getInstance().register(soundProvider);
    }

    @Override
    public Runnable evaluate(ExecutionContext context) {
        SmartSoundManager.getInstance().open(this.soundEvent);
        ISound sound = this.createSound(context);
        this.startPlay(sound);
        return () -> {
            this.stopPlay(sound);
            RenderSystem.recordRenderCall(() -> SmartSoundManager.getInstance().close(this.soundEvent));
        };
    }

    private void startPlay(ISound sound) {
        this.soundManager().func_147682_a(sound);
        if (ModConfig.Client.enableAnimationDebug) {
            ModLog.debug("start play {}", this);
        }
    }

    private void stopPlay(ISound sound) {
        this.soundManager().func_147683_b(sound);
        if (ModConfig.Client.enableAnimationDebug) {
            ModLog.debug("stop play {}", this);
        }
    }

    private ISound createSound(ExecutionContext context) {
        if (context instanceof BlockEntitySelectorImpl) {
            BlockEntitySelectorImpl entity = (BlockEntitySelectorImpl)((Object)context);
            return Constructor.forBlockEntity(ISound.class, this.soundEvent, entity.getEntity(), this.volume, this.pitch);
        }
        if (context instanceof EntitySelectorImpl) {
            EntitySelectorImpl entity = (EntitySelectorImpl)((Object)context);
            return Constructor.forEntity(ISound.class, this.soundEvent, entity.entity(), this.volume, this.pitch);
        }
        return Constructor.forUI(ISound.class, this.soundEvent, this.volume, this.pitch);
    }

    private SoundHandler soundManager() {
        return EnvironmentManager.getClient().func_147118_V();
    }

    public String toString() {
        return Objects.toString(this, "name", this.name);
    }
}

