/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedGeometryQuads;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTransform;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.part.wings.WingPartTransform;
import moe.plushie.armourers_workshop.init.ModDebugger;
import org.apache.commons.lang3.tuple.Pair;

public class BakedSkinPartCombiner {
    public static List<BakedSkinPart> apply(List<BakedSkinPart> skinParts) {
        if (ModDebugger.skinPartCombiner) {
            return skinParts;
        }
        ArrayList<BakedSkinPart> results = new ArrayList<BakedSkinPart>();
        for (BakedSkinPart skinPart : skinParts) {
            results.add(BakedSkinPartCombiner.clip(skinPart));
        }
        return results;
    }

    private static BakedSkinPart clip(BakedSkinPart rootPart) {
        if (rootPart.children().isEmpty()) {
            return rootPart;
        }
        ArrayList<Node> restNodes = new ArrayList<Node>();
        ArrayList<Node> motionNodes = new ArrayList<Node>();
        Node rootNode = new Node(null, rootPart);
        for (Object childNode : rootNode.children) {
            ((Node)childNode).freeze(motionNodes, restNodes);
        }
        ArrayList<Pair<ITransform, BakedGeometryQuads>> pendingQuads = new ArrayList<Pair<ITransform, BakedGeometryQuads>>();
        for (Node node : restNodes) {
            SkinPartTransform resolvedTransform = node.resolveTransform();
            BakedGeometryQuads resolvedQuads = node.part.quads();
            pendingQuads.add((Pair<ITransform, BakedGeometryQuads>)Pair.of((Object)resolvedTransform, (Object)resolvedQuads));
        }
        ArrayList<Pair> childrenParts = new ArrayList<Pair>();
        for (Node childNode : motionNodes) {
            SkinPartTransform transform = childNode.resolveTransform();
            BakedSkinPart part = BakedSkinPartCombiner.clip(childNode.part);
            childrenParts.add(Pair.of((Object)transform, (Object)part));
        }
        BakedGeometryQuads bakedGeometryQuads = BakedGeometryQuads.merge(rootPart.quads(), pendingQuads);
        BakedSkinPart resolvedPart = new BakedSkinPart(rootPart.part(), rootPart.transform(), bakedGeometryQuads);
        for (Pair pair : childrenParts) {
            SkinPartTransform transform = (SkinPartTransform)pair.getKey();
            BakedSkinPart childPart = (BakedSkinPart)pair.getValue();
            if (childPart.transform() == transform) {
                resolvedPart.addPart(childPart);
                continue;
            }
            BakedSkinPart childPart1 = new BakedSkinPart(childPart.part(), transform, childPart.quads());
            childPart.children().forEach(childPart1::addPart);
            resolvedPart.addPart(childPart1);
        }
        return resolvedPart;
    }

    protected static class Node {
        private final BakedSkinPart part;
        private final Node parent;
        private final ArrayList<Node> children = new ArrayList();

        private Node(Node parent, BakedSkinPart part) {
            this.parent = parent;
            this.part = part;
            for (BakedSkinPart childPart : part.children()) {
                this.children.add(new Node(this, childPart));
            }
        }

        public SkinPartTransform resolveTransform() {
            if (this.parent == null) {
                return SkinPartTransform.IDENTITY;
            }
            SkinPartTransform childTransform = this.part.transform();
            SkinPartTransform parentTransform = this.parent.resolveTransform();
            if (parentTransform.isIdentity()) {
                return childTransform;
            }
            if (childTransform.isIdentity()) {
                return parentTransform;
            }
            SkinPartTransform mergedTransform = new SkinPartTransform();
            for (ITransform transform : parentTransform.children()) {
                mergedTransform.addChild(transform);
            }
            for (ITransform transform : childTransform.children()) {
                mergedTransform.addChild(transform);
            }
            return mergedTransform;
        }

        public void freeze(ArrayList<Node> motionNodes, ArrayList<Node> restNodes) {
            if (!this.freeze()) {
                motionNodes.add(this);
                return;
            }
            restNodes.add(this);
            for (Node child : this.children) {
                child.freeze(motionNodes, restNodes);
            }
        }

        private boolean freeze() {
            if (this.part.type() != SkinPartTypes.ADVANCED) {
                return false;
            }
            for (ITransform transform : this.part.transform().children()) {
                if (transform instanceof WingPartTransform) {
                    return false;
                }
                if (!(transform instanceof AnimatedTransform)) continue;
                return false;
            }
            return true;
        }
    }
}

