/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.hologramprojector;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIView;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.client.gui.hologramprojector.HologramProjectorAngleSetting;
import moe.plushie.armourers_workshop.core.client.gui.hologramprojector.HologramProjectorBaseSetting;
import moe.plushie.armourers_workshop.core.client.gui.hologramprojector.HologramProjectorExtraSetting;
import moe.plushie.armourers_workshop.core.client.gui.hologramprojector.HologramProjectorInventorySetting;
import moe.plushie.armourers_workshop.core.client.gui.hologramprojector.HologramProjectorOffsetSetting;
import moe.plushie.armourers_workshop.core.client.gui.hologramprojector.HologramProjectorRotationOffsetSetting;
import moe.plushie.armourers_workshop.core.client.gui.hologramprojector.HologramProjectorRotationSpeedSetting;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.PlayerInventoryView;
import moe.plushie.armourers_workshop.core.client.gui.widget.TabView;
import moe.plushie.armourers_workshop.core.menu.HologramProjectorMenu;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HologramProjectorWindow
extends MenuWindow<HologramProjectorMenu> {
    private final TabView tabView = new TabView(CGRect.ZERO);
    private final HologramProjectorBlockEntity blockEntity;

    public HologramProjectorWindow(HologramProjectorMenu container, PlayerInventory inventory, NSString title) {
        super(container, inventory, title);
        this.titleView.setFrame(this.titleView.bounds().offset(0.0f, 5.0f));
        this.inventoryView.setStyle(PlayerInventoryView.Style.NORMAL);
        this.blockEntity = (HologramProjectorBlockEntity)container.getBlockEntity();
    }

    @Override
    public void init() {
        super.init();
        this.setupTabView();
        this.bringSubviewToFront(this.titleView);
        this.bringSubviewToFront(this.inventoryView);
    }

    @Override
    public void screenWillResize(CGSize size) {
        this.setFrame(new CGRect(0.0f, 0.0f, size.width, size.height));
        this.tabView.setFrame(this.bounds());
        CGRect inv = this.inventoryView.frame();
        ((HologramProjectorMenu)this.menu).reload((int)inv.x, (int)inv.y, (int)size.width, (int)size.height);
    }

    private void setupTabView() {
        this.addTab(new HologramProjectorInventorySetting(this.blockEntity)).setIcon(this.tabIcon(64, 0, 8, 150)).setTarget(1);
        this.addTab(new HologramProjectorOffsetSetting(this.blockEntity)).setIcon(this.tabIcon(96, 0, 8, 150));
        this.addTab(new HologramProjectorAngleSetting(this.blockEntity)).setIcon(this.tabIcon(176, 0, 8, 150));
        this.addTab(new HologramProjectorRotationOffsetSetting(this.blockEntity)).setIcon(this.tabIcon(80, 0, 8, 150));
        this.addTab(new HologramProjectorRotationSpeedSetting(this.blockEntity)).setIcon(this.tabIcon(160, 0, 4, 150));
        this.addTab(new HologramProjectorExtraSetting(this.blockEntity)).setIcon(this.tabIcon(144, 0, 8, 150));
        this.tabView.addTarget(this, HologramProjectorWindow::switchTab);
        this.tabView.setSelectedTab(this.tabView.firstActiveTab());
        this.tabView.setFullscreenMode(true);
        this.addSubview(this.tabView);
    }

    private void switchTab(TabView.Entry entry) {
        int group = 0;
        Object value = entry.target();
        if (value != null) {
            group = (Integer)value;
        }
        ((HologramProjectorMenu)this.menu).setGroup(group);
        this.inventoryView.setHidden(!((HologramProjectorMenu)this.menu).shouldRenderInventory());
    }

    private TabView.EntryBuilder addTab(HologramProjectorBaseSetting contentView) {
        WrappedContainer containerView = new WrappedContainer(contentView);
        return this.tabView.addContentView(containerView).setTooltip(contentView.title());
    }

    private UIImage tabIcon(int u, int v, int frame, int speed) {
        return UIImage.of(ModTextures.TAB_ICONS).uv(u, v).fixed(16.0f, 16.0f).animation(frame, speed).build();
    }

    @Override
    public boolean shouldRenderBackground() {
        return false;
    }

    public static class WrappedContainer
    extends UIView {
        private final HologramProjectorBaseSetting setting;

        public WrappedContainer(HologramProjectorBaseSetting setting) {
            super(CGRect.ZERO);
            this.setting = setting;
            this.addSubview(setting);
        }

        @Override
        public void layoutSubviews() {
            super.layoutSubviews();
            this.setting.setCenter(new CGPoint(this.bounds().width() / 2.0f, this.setting.bounds().height() / 2.0f));
        }

        @Override
        @Nullable
        public UIView hitTest(CGPoint point, UIEvent event) {
            UIView target = super.hitTest(point, event);
            if (target != this) {
                return target;
            }
            return null;
        }
    }
}

