/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;

public class SkinBlockPlaceContext
extends BlockItemUseContext {
    private OpenVector3f rotations = OpenVector3f.ZERO;
    private SkinDescriptor skin = SkinDescriptor.EMPTY;
    private ArrayList<Part> parts = new ArrayList();
    private SkinProperties properties;

    public SkinBlockPlaceContext(ItemUseContext context) {
        super(context);
        this.loadElements(SkinLoader.getInstance()::loadSkin);
    }

    public SkinBlockPlaceContext(PlayerEntity player, Hand hand, ItemStack itemStack, BlockRayTraceResult traceResult) {
        super(PropertyProvider.getLevel((Entity)player), player, hand, itemStack, traceResult);
        this.loadElements(SkinLoader.getInstance()::getSkin);
    }

    public static SkinBlockPlaceContext of(BlockPos pos) {
        if (pos instanceof AttachedBlockPos) {
            AttachedBlockPos pos1 = (AttachedBlockPos)pos;
            return pos1.context;
        }
        return null;
    }

    protected void transform(OpenVector3f r) {
        for (Part part : this.parts) {
            part.transform(r);
        }
    }

    protected void loadElements(Function<String, Skin> provider) {
        ItemStack itemStack = this.func_195996_i();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return;
        }
        Skin skin = provider.apply(descriptor.identifier());
        if (skin == null) {
            return;
        }
        ArrayList parts = new ArrayList();
        ArrayList<ParentPart> parentParts = new ArrayList<ParentPart>();
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        skin.blockBounds().forEach((pos, shape) -> {
            OpenRectangle3i rect = new OpenRectangle3i((IRectangle3f)shape);
            if (pos.equals(OpenVector3i.ZERO)) {
                ParentPart part = new ParentPart(BlockPos.field_177992_a, rect, descriptor, skin);
                parts.add(part);
                parentParts.add(part);
            } else {
                Part part = new Part(new BlockPos(pos.x(), pos.y(), pos.z()), rect);
                parts.add(part);
            }
        });
        this.skin = descriptor;
        this.parts = parts;
        this.properties = skin.properties();
        BlockState state = ((Block)ModBlocks.SKINNABLE.get()).func_196258_a((BlockItemUseContext)this);
        if (state != null) {
            this.rotations = SkinnableBlockEntity.getRotations(state);
            this.transform(this.rotations);
        }
        for (Part part : parts) {
            blockPosList.add(part.offset());
        }
        parentParts.forEach(it -> it.setReferences(blockPosList));
    }

    public <V> V getProperty(SkinProperty<V> property) {
        if (this.properties != null && !this.properties.isEmpty()) {
            return this.properties.get(property);
        }
        return property.defaultValue();
    }

    public boolean canPlace(Part part) {
        if (this.skin.isEmpty()) {
            return false;
        }
        if (this.skin.type() != SkinTypes.BLOCK) {
            return false;
        }
        BlockPos pos = super.func_195995_a().func_177971_a((Vector3i)part.offset());
        return this.func_195991_k().func_180495_p(pos).func_196953_a((BlockItemUseContext)this);
    }

    public boolean func_196011_b() {
        return this.parts != null && this.parts.stream().allMatch(this::canPlace) && super.func_196011_b();
    }

    public BlockPos func_195995_a() {
        return new AttachedBlockPos(this, super.func_195995_a());
    }

    public SkinDescriptor skin() {
        return this.skin;
    }

    public ArrayList<Part> parts() {
        return this.parts;
    }

    public static class AttachedBlockPos
    extends BlockPos {
        protected final SkinBlockPlaceContext context;

        public AttachedBlockPos(SkinBlockPlaceContext context, BlockPos pos) {
            super((Vector3i)pos);
            this.context = context;
        }
    }

    public static class Part
    implements IDataSerializable.Immutable {
        private BlockPos offset;
        private OpenRectangle3i shape;

        public Part() {
            this(BlockPos.field_177992_a, OpenRectangle3i.ZERO);
        }

        public Part(BlockPos offset, OpenRectangle3i shape) {
            this.offset = offset;
            this.shape = shape;
        }

        @Override
        public void serialize(IDataSerializer serializer) {
            serializer.write(CodingKeys.REFERENCE, this.offset);
            serializer.write(CodingKeys.SHAPE, this.shape);
        }

        public void transform(OpenVector3f r) {
            OpenQuaternionf q = new OpenQuaternionf(r.x(), r.y(), r.z(), true);
            OpenVector4f f = new OpenVector4f(this.offset.func_177958_n(), this.offset.func_177956_o(), this.offset.func_177952_p(), 1.0f);
            f.transform(q);
            this.offset = new BlockPos(Math.round(f.x()), Math.round(f.y()), Math.round(f.z()));
            OpenRectangle3f fixedShape = new OpenRectangle3f(this.shape);
            fixedShape.mul(q);
            this.shape = new OpenRectangle3i(Math.round(fixedShape.x()), Math.round(fixedShape.y()), Math.round(fixedShape.z()), Math.round(fixedShape.width()), Math.round(fixedShape.height()), Math.round(fixedShape.depth()));
        }

        public BlockPos offset() {
            return this.offset;
        }

        public OpenRectangle3i shape() {
            return this.shape;
        }
    }

    public static class ParentPart
    extends Part {
        private final SkinDescriptor descriptor;
        private final SkinProperties properties;
        private List<BlockPos> references = Collections.emptyList();
        private List<SkinMarker> markerList;

        public ParentPart(BlockPos offset, OpenRectangle3i shape, SkinDescriptor descriptor, Skin skin) {
            super(offset, shape);
            this.descriptor = descriptor;
            this.properties = skin.properties();
            this.markerList = Collections.newList(skin.markers());
        }

        @Override
        public void serialize(IDataSerializer serializer) {
            super.serialize(serializer);
            serializer.write(CodingKeys.REFERENCES, this.references);
            serializer.write(CodingKeys.MARKERS, this.markerList);
            serializer.write(CodingKeys.SKIN, this.descriptor);
            serializer.write(CodingKeys.SKIN_PROPERTIES, this.properties);
        }

        @Override
        public void transform(OpenVector3f r) {
            super.transform(r);
            OpenQuaternionf q = new OpenQuaternionf(r.x(), r.y(), r.z(), true);
            ArrayList<SkinMarker> newMarkerList = new ArrayList<SkinMarker>();
            for (SkinMarker marker : this.markerList) {
                OpenVector4f f = new OpenVector4f(marker.x, marker.y, marker.z, 1.0f);
                f.transform(OpenMatrix4f.createScaleMatrix(-1.0f, -1.0f, 1.0f));
                f.transform(q);
                int x = Math.round(f.x());
                int y = Math.round(f.y());
                int z = Math.round(f.z());
                marker = new SkinMarker((byte)x, (byte)y, (byte)z, marker.meta);
                newMarkerList.add(marker);
            }
            this.markerList = newMarkerList;
        }

        public void setReferences(List<BlockPos> blockPosList) {
            this.references = blockPosList;
        }

        public List<BlockPos> references() {
            return this.references;
        }
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<BlockPos> REFERENCE = IDataSerializerKey.create("Refer", IDataCodec.BLOCK_POS, BlockPos.field_177992_a);
        public static final IDataSerializerKey<OpenRectangle3i> SHAPE = IDataSerializerKey.create("Shape", OpenRectangle3i.CODEC, OpenRectangle3i.ZERO);
        public static final IDataSerializerKey<BlockPos> LINKED_POS = IDataSerializerKey.create("LinkedPos", IDataCodec.BLOCK_POS, null);
        public static final IDataSerializerKey<SkinDescriptor> SKIN = IDataSerializerKey.create("Skin", SkinDescriptor.CODEC, SkinDescriptor.EMPTY);
        public static final IDataSerializerKey<SkinProperties> SKIN_PROPERTIES = IDataSerializerKey.create("SkinProperties", SkinProperties.CODEC, SkinProperties.EMPTY, SkinProperties.EMPTY::copy);
        public static final IDataSerializerKey<List<BlockPos>> REFERENCES = IDataSerializerKey.create("Refers", IDataCodec.BLOCK_POS.listOf(), Collections.emptyList());
        public static final IDataSerializerKey<List<SkinMarker>> MARKERS = IDataSerializerKey.create("Markers", SkinMarker.CODEC.listOf(), Collections.emptyList());

        private CodingKeys() {
        }
    }
}

