/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;

public class OpenNearPlane {
    private final float fov;
    private final float width;
    private final float height;
    private final OpenVector3f forwards = new OpenVector3f(0.0f, 0.0f, 1.0f);
    private final OpenVector3f up = new OpenVector3f(0.0f, 1.0f, 0.0f);
    private final OpenVector3f left = new OpenVector3f(1.0f, 0.0f, 0.0f);

    public OpenNearPlane(float rx, float ry, float width, float height, float fov) {
        OpenQuaternionf quaternion = OpenQuaternionf.fromEulerAnglesYXZ(-ry, rx, 0.0f, true);
        this.forwards.transform(quaternion);
        this.up.transform(quaternion);
        this.left.transform(quaternion);
        this.fov = fov;
        this.width = width;
        this.height = height;
    }

    public OpenVector3f at(float deltaX, float deltaY, float deltaZ) {
        float d0 = this.width / this.height;
        float d1 = (float)Math.tan((double)this.fov / 2.0 * (Math.PI / 180));
        float sx = deltaX * deltaZ * d1 * d0;
        float sy = deltaY * deltaZ * d1;
        float sz = deltaZ;
        float tx = this.forwards.x() * sz + this.up.x() * sy - this.left.x() * sx;
        float ty = this.forwards.y() * sz + this.up.y() * sy - this.left.y() * sx;
        float tz = this.forwards.z() * sz + this.up.z() * sy - this.left.z() * sx;
        return new OpenVector3f(tx, ty, tz);
    }

    public OpenVector3f lookVector() {
        return this.forwards;
    }

    public OpenVector3f upVector() {
        return this.up;
    }

    public OpenVector3f leftVector() {
        return this.left;
    }
}

