/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.client.gui.notification.UserNotificationCenter;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class ExecuteAlertPacket
extends CustomPacket {
    private final ITextComponent title;
    private final ITextComponent message;
    private final ITextComponent confirm;
    private final CompoundNBT icon;
    private final int type;

    public ExecuteAlertPacket(ITextComponent title, ITextComponent message, ITextComponent confirm, int type, CompoundNBT nbt) {
        this.title = title;
        this.message = message;
        this.confirm = confirm;
        this.type = type;
        this.icon = nbt;
    }

    public ExecuteAlertPacket(IFriendlyByteBuf buffer) {
        this.title = buffer.readComponent();
        this.message = buffer.readComponent();
        this.confirm = buffer.readComponent();
        this.type = buffer.readInt();
        this.icon = buffer.readNbt();
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeComponent(this.title);
        buffer.writeComponent(this.message);
        buffer.writeComponent(this.confirm);
        buffer.writeInt(this.type);
        buffer.writeNbt(this.icon);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        UserNotificationCenter.showAlertFromServer(this);
    }

    public ITextComponent title() {
        return this.title;
    }

    public ITextComponent message() {
        return this.message;
    }

    public ITextComponent confirm() {
        return this.confirm;
    }

    public CompoundNBT icon() {
        return this.icon;
    }

    public int type() {
        return this.type;
    }
}

