/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractEntityDataSerializer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.EntityCollisionShape;
import moe.plushie.armourers_workshop.core.data.GenericProperties;
import moe.plushie.armourers_workshop.core.data.GenericProperty;
import moe.plushie.armourers_workshop.core.data.GenericValue;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.menu.SkinWardrobeMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.Nullable;

public class UpdateWardrobePacket
extends CustomPacket {
    private final Type type;
    private final int entityId;
    private final GenericValue<SkinWardrobe, ?> fieldValue;
    private final CompoundNBT compoundTag;

    public UpdateWardrobePacket(IFriendlyByteBuf buffer) {
        this.type = buffer.readEnum(Type.class);
        this.entityId = buffer.readInt();
        if (this.type != Type.SYNC_OPTION) {
            this.fieldValue = null;
            this.compoundTag = buffer.readNbt();
        } else {
            this.fieldValue = Field.TYPE.read(buffer);
            this.compoundTag = null;
        }
    }

    public UpdateWardrobePacket(SkinWardrobe wardrobe, Type mode, CompoundNBT compoundTag, GenericValue<SkinWardrobe, ?> fieldValue) {
        this.type = mode;
        this.entityId = wardrobe.id();
        this.fieldValue = fieldValue;
        this.compoundTag = compoundTag;
    }

    public static UpdateWardrobePacket sync(SkinWardrobe wardrobe) {
        TagSerializer serializer = new TagSerializer(new CompoundNBT(), wardrobe.entity());
        wardrobe.serialize(serializer);
        return new UpdateWardrobePacket(wardrobe, Type.SYNC, serializer.tag(), null);
    }

    public static UpdateWardrobePacket dying(SkinWardrobe wardrobe, int slot, SkinPaintColor color) {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("Slot", slot);
        compoundNBT.func_74768_a("Color", color.rawValue());
        return new UpdateWardrobePacket(wardrobe, Type.SYNC_ITEM, compoundNBT, null);
    }

    public static UpdateWardrobePacket field(SkinWardrobe wardrobe, GenericValue<SkinWardrobe, ?> fieldValue) {
        return new UpdateWardrobePacket(wardrobe, Type.SYNC_OPTION, null, fieldValue);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum(this.type);
        buffer.writeInt(this.entityId);
        if (this.compoundTag != null) {
            buffer.writeNbt(this.compoundTag);
        }
        if (this.fieldValue != null) {
            this.fieldValue.write(buffer);
        }
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        if (!(player.field_71070_bA instanceof SkinWardrobeMenu)) {
            ModLog.info("reject {} operation for '{}'", this.operator(), player.func_195047_I_());
            return;
        }
        if (!this.checkSecurityByServer()) {
            ModLog.info("reject {} operation for '{}', for security reasons.", this.operator(), player.func_195047_I_());
            return;
        }
        ModLog.debug("accept {} operation for '{}'", this.operator(), player.func_195047_I_());
        SkinWardrobe wardrobe = this.apply((PlayerEntity)player);
        if (wardrobe != null) {
            NetworkManager.sendToTracking(this, (Entity)player);
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        this.apply(player);
    }

    @Nullable
    private SkinWardrobe apply(PlayerEntity player) {
        SkinWardrobe skinWardrobe;
        SkinWardrobe wardrobe = SkinWardrobe.of(PropertyProvider.getLevel((Entity)player).func_73045_a(this.entityId));
        if (wardrobe == null) {
            return null;
        }
        switch (this.type.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                TagSerializer serializer = new TagSerializer(this.compoundTag, player);
                wardrobe.deserialize(serializer);
                skinWardrobe = wardrobe;
                break;
            }
            case 2: {
                if (this.fieldValue != null) {
                    this.fieldValue.apply(wardrobe);
                    skinWardrobe = wardrobe;
                    break;
                }
                skinWardrobe = null;
                break;
            }
            case 1: {
                IInventory inventory = wardrobe.inventory();
                int slot = OptionalAPI.getOptionalInt(this.compoundTag, "Slot").orElse(0);
                if (slot < inventory.func_70302_i_()) {
                    ItemStack itemStack = ItemStack.field_190927_a;
                    SkinPaintColor color = SkinPaintColor.of(OptionalAPI.getOptionalInt(this.compoundTag, "Color").orElse(0));
                    if (!color.isEmpty()) {
                        ItemStack newItemStack = new ItemStack((IItemProvider)ModItems.BOTTLE.get());
                        ComponentAPI.set(newItemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), color);
                        itemStack = newItemStack;
                    }
                    inventory.func_70299_a(slot, itemStack);
                    skinWardrobe = wardrobe;
                    break;
                }
                skinWardrobe = null;
                break;
            }
        }
        return skinWardrobe;
    }

    private boolean checkSecurityByServer() {
        boolean bl;
        switch (this.type.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 1: {
                int slot = OptionalAPI.getOptionalInt(this.compoundTag, "Slot").orElse(0);
                int index = slot - SkinSlotType.DYE.index();
                if (index < 8 || index >= SkinSlotType.DYE.maxSize()) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
        }
        return bl;
    }

    private Object operator() {
        if (this.fieldValue != null) {
            return this.fieldValue.property();
        }
        return this.type;
    }

    public static enum Type {
        SYNC,
        SYNC_ITEM,
        SYNC_OPTION;

    }

    public static final class Field<T>
    extends GenericProperty<SkinWardrobe, T> {
        private static final GenericProperties<SkinWardrobe> TYPE = GenericProperties.of(SkinWardrobe.class, UpdateWardrobePacket::field);
        public static final Field<Boolean> WARDROBE_ARMOUR_HEAD = Field.wardrobe(OpenEquipmentSlot.HEAD);
        public static final Field<Boolean> WARDROBE_ARMOUR_CHEST = Field.wardrobe(OpenEquipmentSlot.CHEST);
        public static final Field<Boolean> WARDROBE_ARMOUR_LEGS = Field.wardrobe(OpenEquipmentSlot.LEGS);
        public static final Field<Boolean> WARDROBE_ARMOUR_FEET = Field.wardrobe(OpenEquipmentSlot.FEET);
        public static final Field<Boolean> WARDROBE_EXTRA_RENDER = Field.wardrobe(SkinWardrobe::shouldRenderExtra, SkinWardrobe::setRenderExtra);
        public static final Field<EntityCollisionShape> WARDROBE_COLLISION_SHAPE = Field.wardrobe(SkinWardrobe::collisionShape, SkinWardrobe::setCollisionShape, DataSerializers.COLLISION_SHAPE_OPT);
        public static final Field<Boolean> MANNEQUIN_IS_CHILD = Field.entity(MannequinEntity.DATA_IS_CHILD);
        public static final Field<Boolean> MANNEQUIN_IS_FLYING = Field.entity(MannequinEntity.DATA_IS_FLYING);
        public static final Field<Boolean> MANNEQUIN_IS_VISIBLE = Field.entity(MannequinEntity.DATA_IS_VISIBLE);
        public static final Field<Boolean> MANNEQUIN_IS_GHOST = Field.entity(MannequinEntity.DATA_IS_GHOST);
        public static final Field<Boolean> MANNEQUIN_EXTRA_RENDER = Field.entity(MannequinEntity.DATA_EXTRA_RENDERER);
        public static final Field<Boolean> MANNEQUIN_NO_GRAVITY = Field.entity(MannequinEntity.DATA_NO_GRAVITY);
        public static final Field<CompoundNBT> MANNEQUIN_POSE = Field.entity(MannequinEntity::saveCustomPose, MannequinEntity::readCustomPose, DataSerializers.COMPOUND_TAG);
        public static final Field<Vector3d> MANNEQUIN_POSITION = Field.entity(Entity::func_213303_ch, Entity::func_233576_c_, DataSerializers.VECTOR_3D);
        public static final Field<EntityTextureDescriptor> MANNEQUIN_TEXTURE = Field.entity(MannequinEntity.DATA_TEXTURE);
        public static final Field<EntityTextureDescriptor.Model> MANNEQUIN_TEXTURE_MODEL = Field.entity(MannequinEntity.DATA_TEXTURE_MODEL);

        private static Field<Boolean> wardrobe(OpenEquipmentSlot slotType) {
            return Field.wardrobe(source -> source.shouldRenderEquipment(slotType), (source, value) -> source.setRenderEquipment(slotType, (boolean)value), DataSerializers.BOOLEAN);
        }

        private static Field<Boolean> wardrobe(Function<SkinWardrobe, Boolean> supplier, BiConsumer<SkinWardrobe, Boolean> applier) {
            return Field.wardrobe(supplier, applier, DataSerializers.BOOLEAN);
        }

        private static <T> Field<T> wardrobe(Function<SkinWardrobe, T> supplier, BiConsumer<SkinWardrobe, T> applier, IEntitySerializer<T> dataSerializer) {
            return TYPE.create(dataSerializer).getter(supplier).setter(applier).build(Field::new);
        }

        private static <T> Field<T> entity(DataParameter<T> dataParameter) {
            return Field.entity(entity -> entity.func_184212_Q().func_187225_a(dataParameter), (entity, value) -> entity.func_184212_Q().func_187227_b(dataParameter, value), AbstractEntityDataSerializer.wrap(dataParameter));
        }

        private static <S extends Entity, T> Field<T> entity(Function<S, T> supplier, BiConsumer<S, T> applier, IEntitySerializer<T> dataSerializer) {
            return TYPE.create(dataSerializer).getter(source -> {
                Entity entity = source.entity();
                if (entity != null) {
                    return supplier.apply((Entity)Objects.unsafeCast(entity));
                }
                return null;
            }).setter((source, value) -> {
                Entity entity = source.entity();
                if (entity != null) {
                    applier.accept((Entity)Objects.unsafeCast(entity), value);
                }
            }).build(Field::new);
        }
    }
}

