/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;

public class ParticleKillInPlaneLifetime
extends SkinParticleComponent {
    private final float a;
    private final float b;
    private final float c;
    private final float d;

    public ParticleKillInPlaneLifetime(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public ParticleKillInPlaneLifetime(IInputStream stream) throws IOException {
        this.a = stream.readFloat();
        this.b = stream.readFloat();
        this.c = stream.readFloat();
        this.d = stream.readFloat();
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writeFloat(this.a);
        stream.writeFloat(this.b);
        stream.writeFloat(this.c);
        stream.writeFloat(this.d);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        builder.updateParticle((emitter, particle, context) -> {
            if (!particle.isAlive()) {
                return;
            }
            OpenVector3f p0 = particle.getLocalPositionOld();
            OpenVector3f p1 = particle.getLocalPosition();
            float prev = this.a * p0.x() + this.b * p0.y() + this.c * p0.z() + this.d;
            float now = this.a * p1.x() + this.b * p1.y() + this.c * p1.y() + this.d;
            if (prev > 0.0f && now < 0.0f || prev < 0.0f && now > 0.0f) {
                particle.kill();
            }
        });
    }
}

