/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data.impl;

import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;

public class ServerToken {
    private final String serverId;
    private final String accessToken;
    private final long receivedTime;
    private final long expiryTime;

    public ServerToken(IODataObject object) {
        this.serverId = object.get("server_id").stringValue();
        this.accessToken = object.get("accessToken").stringValue();
        this.expiryTime = object.get("expiryTime").intValue();
        this.receivedTime = System.currentTimeMillis();
    }

    public boolean isValid() {
        return this.remainingTime() >= 0L;
    }

    public String value() {
        return this.accessToken;
    }

    public String serverId() {
        return this.serverId;
    }

    public long remainingTime() {
        return this.receivedTime + this.expiryTime * 1000L - System.currentTimeMillis();
    }
}

